/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j62056.app;

import java.util.ArrayList;
import org.openmuc.j62056.internal.cli.CliParameter;
import org.openmuc.j62056.internal.cli.CliParameterBuilder;
import org.openmuc.j62056.internal.cli.CliParseException;
import org.openmuc.j62056.internal.cli.CliParser;
import org.openmuc.j62056.internal.cli.FlagCliParameter;
import org.openmuc.j62056.internal.cli.IntCliParameter;
import org.openmuc.j62056.internal.cli.StringCliParameter;

class ConsoleLineParser {
    private final CliParser cliParser;
    public final StringCliParameter serialPortName = new CliParameterBuilder("-p").setDescription("The serial port used for communication. Examples are /dev/ttyS0 (Linux) or COM1 (Windows).").setMandatory().buildStringParameter("serial_port");
    public final IntCliParameter initialBaudRate = new CliParameterBuilder("-b").setDescription("Initial baud rate of the serial port.").buildIntParameter("baud_rate", 300);
    public final IntCliParameter baudRateChangeDelay = new CliParameterBuilder("-d").setDescription("Delay of baud rate change in ms. USB to serial converters often require a delay of up to 250ms.").buildIntParameter("baud_rate_change_delay", 0);
    public final IntCliParameter timeout = new CliParameterBuilder("-t").setDescription("The timeout in ms.").buildIntParameter("timeout", 5000);
    public final FlagCliParameter verbose = new CliParameterBuilder("-v").setDescription("Enable verbose mode to print debug messages to standard out.").buildFlagParameter();
    public final FlagCliParameter fixedBaudRate = new CliParameterBuilder("-f").setDescription("Fixed baud rate. In mode C the baud rate starts with 300 and then by default changes to a value suggested by the meter. The baud rate will NOT be changed with this flag enabled.").buildFlagParameter();
    public final FlagCliParameter listen = new CliParameterBuilder("-l").setDescription("Listen for mode D messages instead of reading the meter using mode A, B or C.").buildFlagParameter();
    public final StringCliParameter deviceAddress = new CliParameterBuilder("-a").setDescription("The device address that is sent with the request message in modes A, B, and C.").buildStringParameter("device_address", "");
    public final StringCliParameter requestStartCharacters = new CliParameterBuilder("-rsc").setDescription("Set the request message start characters.").buildStringParameter("request_start_character", "/?");

    ConsoleLineParser() {
        ArrayList<CliParameter> parameters = new ArrayList<CliParameter>();
        parameters.add(this.serialPortName);
        parameters.add(this.initialBaudRate);
        parameters.add(this.baudRateChangeDelay);
        parameters.add(this.timeout);
        parameters.add(this.verbose);
        parameters.add(this.fixedBaudRate);
        parameters.add(this.listen);
        parameters.add(this.deviceAddress);
        parameters.add(this.requestStartCharacters);
        this.cliParser = new CliParser("j62056-console-client", "IEC 62056-21 client application to read meters using modes A, B, C or D");
        this.cliParser.addParameters(parameters);
    }

    public void parse(String[] args) throws CliParseException {
        this.cliParser.parseArguments(args);
    }

    public void printUsage() {
        System.out.println(this.cliParser.getUsageString());
    }
}

