/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j62056.internal;

public enum AcknowledgeMode {
    DATA_READOUT('0'),
    PROGRAMMING('1'),
    BINARY('2'),
    RESERVED('3'),
    MANUFACTURE('6');

    private char value;

    private AcknowledgeMode(char value) {
        this.value = value;
    }

    public char value() {
        return this.value;
    }

    public static AcknowledgeMode valueOf(char mode) {
        switch (mode) {
            case '0': {
                return DATA_READOUT;
            }
            case '1': {
                return PROGRAMMING;
            }
            case '2': {
                return BINARY;
            }
            case '3': 
            case '4': 
            case '5': {
                return RESERVED;
            }
        }
        if (mode >= '6' && mode <= '9' || mode >= 'A' && mode <= 'Z') {
            return MANUFACTURE;
        }
        throw new IllegalArgumentException("Unsupported control mode.");
    }
}

