/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j62056.internal;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j62056.internal.HexConverter;

public class SelectReplyMessage {
    private final String selectReplyMessageString;

    public SelectReplyMessage(DataInputStream is) throws IOException {
        byte b = is.readByte();
        if (b != 47) {
            throw new IOException("Received unexpected select reply message start byte: " + HexConverter.toShortHexString(b));
        }
        StringBuilder sb = new StringBuilder();
        b = is.readByte();
        while (b != 13) {
            sb.append((char)b);
            b = is.readByte();
        }
        this.selectReplyMessageString = sb.toString();
        b = is.readByte();
        if (b != 10) {
            throw new IOException("Received unexpected identification message end byte: " + HexConverter.toShortHexString(b));
        }
    }

    public String getReplyMessage() {
        return this.selectReplyMessageString;
    }

    public String toString() {
        return "{\"reply message\": {\"reply\": \"" + this.selectReplyMessageString + "}}";
    }
}

