/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber;

import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;

public class BerIdentifier {
    public static final int UNIVERSAL_CLASS = 0;
    public static final int APPLICATION_CLASS = 64;
    public static final int CONTEXT_CLASS = 128;
    public static final int PRIVATE_CLASS = 192;
    public static final int PRIMITIVE = 0;
    public static final int CONSTRUCTED = 32;
    public static final int BOOLEAN_TAG = 1;
    public static final int INTEGER_TAG = 2;
    public static final int BIT_STRING_TAG = 3;
    public static final int OCTET_STRING_TAG = 4;
    public static final int NULL_TAG = 5;
    public static final int OBJECT_IDENTIFIER_TAG = 6;
    public static final int REAL_TAG = 9;
    public static final int ENUMERATED_TAG = 10;
    public static final int UTF8_STRING_TAG = 12;
    public static final int NUMERIC_STRING_TAG = 18;
    public static final int PRINTABLE_STRING_TAG = 19;
    public static final int TELETEX_STRING_TAG = 20;
    public static final int VIDEOTEX_STRING_TAG = 21;
    public static final int IA5_STRING_TAG = 22;
    public static final int GENERALIZED_TIME_TAG = 24;
    public static final int GRAPHIC_STRING_TAG = 25;
    public static final int VISIBLE_STRING_TAG = 26;
    public static final int GENERAL_STRING_TAG = 27;
    public static final int UNIVERSAL_STRING_TAG = 28;
    public static final int BMP_STRING_TAG = 30;
    public byte[] identifier = null;
    public int identifierClass;
    public int primitive;
    public int tagNumber;

    public BerIdentifier(int identifierClass, int primitive, int tagNumber) {
        this.identifierClass = identifierClass;
        this.primitive = primitive;
        this.tagNumber = tagNumber;
        this.code();
    }

    public BerIdentifier() {
    }

    private void code() {
        if (this.tagNumber < 31) {
            this.identifier = new byte[1];
            this.identifier[0] = (byte)(this.identifierClass | this.primitive | this.tagNumber);
        } else {
            int tagLength = 1;
            while ((double)this.tagNumber > Math.pow(2.0, 7 * tagLength) - 1.0) {
                ++tagLength;
            }
            this.identifier = new byte[1 + tagLength];
            this.identifier[0] = (byte)(this.identifierClass | this.primitive | 0x1F);
            for (int j = 1; j <= tagLength - 1; ++j) {
                this.identifier[j] = (byte)(this.tagNumber >> 7 * (tagLength - j) & 0xFF | 0x80);
            }
            this.identifier[tagLength] = (byte)(this.tagNumber & 0x7F);
        }
    }

    public int encode(BerByteArrayOutputStream berOStream) throws IOException {
        for (int i = this.identifier.length - 1; i >= 0; --i) {
            berOStream.write(this.identifier[i]);
        }
        return this.identifier.length;
    }

    public int decode(InputStream iStream) throws IOException {
        byte nextByte = (byte)iStream.read();
        this.identifierClass = nextByte & 0xC0;
        this.primitive = nextByte & 0x20;
        this.tagNumber = nextByte & 0x1F;
        int codeLength = 1;
        if (this.tagNumber == 31) {
            this.tagNumber = 0;
            int counter = 0;
            do {
                nextByte = (byte)iStream.read();
                ++codeLength;
                if (counter >= 6) {
                    throw new IOException("Invalid Tag");
                }
                this.tagNumber <<= 7;
                this.tagNumber |= nextByte & 0x7F;
                ++counter;
            } while ((nextByte & 0x80) == 128);
        }
        return codeLength;
    }

    public int decodeAndCheck(InputStream iStream) throws IOException {
        byte[] arr$ = this.identifier;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Byte myByte = arr$[i$];
            if (iStream.read() == (myByte & 0xFF)) continue;
            throw new IOException("Identifier does not match!");
        }
        return this.identifier.length;
    }

    public boolean equals(int identifierClass, int primitive, int tagNumber) {
        return this.identifierClass == identifierClass && this.primitive == primitive && this.tagNumber == tagNumber;
    }

    public boolean equals(BerIdentifier berIdentifier) {
        return this.identifierClass == berIdentifier.identifierClass && this.primitive == berIdentifier.primitive && this.tagNumber == berIdentifier.tagNumber;
    }

    public String toString() {
        return "identifierClass: " + this.identifierClass + " primitive: " + this.primitive + "Tag Number: " + this.tagNumber;
    }
}

