/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber;

import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;

public class BerLength {
    public int val;

    public int decode(InputStream iStream) throws IOException {
        this.val = iStream.read();
        int length = 1;
        if ((this.val & 0x80) != 0) {
            int lengthLength = this.val & 0x7F;
            if (lengthLength == 0) {
                this.val = -1;
                return 1;
            }
            if (lengthLength > 4) {
                throw new IOException("Length is out of bound!");
            }
            this.val = 0;
            byte[] byteCode = new byte[lengthLength];
            if (iStream.read(byteCode, 0, lengthLength) == -1) {
                throw new IOException("Error Decoding ASN1Integer");
            }
            length += lengthLength;
            for (int i = 0; i < lengthLength; ++i) {
                this.val |= (byteCode[i] & 0xFF) << 8 * (lengthLength - i - 1);
            }
        }
        return length;
    }

    public static int encodeLength(BerByteArrayOutputStream berOStream, int length) throws IOException {
        if (length <= 127) {
            berOStream.write((byte)length);
            return 1;
        }
        int numLengthBytes = 1;
        while ((int)(Math.pow(2.0, 8 * numLengthBytes) - 1.0) < length) {
            ++numLengthBytes;
        }
        for (int i = 0; i < numLengthBytes; ++i) {
            berOStream.write(length >> 8 * i & 0xFF);
        }
        berOStream.write(0x80 | numLengthBytes);
        return 1 + numLengthBytes;
    }
}

