/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerIdentifier;
import org.openmuc.jasn1.ber.BerLength;

public class BerBitString {
    public static final BerIdentifier identifier = new BerIdentifier(0, 0, 3);
    protected BerIdentifier id = identifier;
    public byte[] code = null;
    public byte[] bitString;
    public int numBits;

    public BerBitString() {
    }

    public BerBitString(byte[] bitString, int numBits) {
        if (numBits < (bitString.length - 1) * 8 + 1 || numBits > bitString.length * 8) {
            throw new IllegalArgumentException("numBits out of bound.");
        }
        this.bitString = bitString;
        this.numBits = numBits;
    }

    public BerBitString(byte[] code) {
        this.code = code;
    }

    public int encode(BerByteArrayOutputStream berOStream, boolean explicit) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                berOStream.write(this.code[i]);
            }
        } else {
            for (int i = this.bitString.length - 1; i >= 0; --i) {
                berOStream.write(this.bitString[i]);
            }
            berOStream.write(this.bitString.length * 8 - this.numBits);
            codeLength = this.bitString.length + 1;
            codeLength += BerLength.encodeLength(berOStream, codeLength);
        }
        if (explicit) {
            codeLength += this.id.encode(berOStream);
        }
        return codeLength;
    }

    public int decode(InputStream iStream, boolean explicit) throws IOException {
        int codeLength = 0;
        if (explicit) {
            codeLength += this.id.decodeAndCheck(iStream);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(iStream);
        this.bitString = new byte[length.val - 1];
        this.numBits = this.bitString.length * 8 - iStream.read();
        if (this.bitString.length > 0 && iStream.read(this.bitString, 0, this.bitString.length) < this.bitString.length) {
            throw new IOException("Error Decoding BerBitString");
        }
        return codeLength += this.bitString.length + 1;
    }
}

