/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerIdentifier;
import org.openmuc.jasn1.ber.BerLength;

public class BerBoolean {
    public static final BerIdentifier identifier = new BerIdentifier(0, 0, 1);
    public BerIdentifier id = identifier;
    public byte[] code = null;
    public boolean val;

    public BerBoolean() {
    }

    public BerBoolean(byte[] code) {
        this.code = code;
    }

    public BerBoolean(boolean val) {
        this.val = val;
    }

    public int encode(BerByteArrayOutputStream berOStream, boolean explicit) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                berOStream.write(this.code[i]);
            }
        } else {
            codeLength = 1;
            if (this.val) {
                berOStream.write(255);
            } else {
                berOStream.write(0);
            }
            codeLength += BerLength.encodeLength(berOStream, codeLength);
        }
        if (explicit) {
            codeLength += this.id.encode(berOStream);
        }
        return codeLength;
    }

    public int decode(InputStream iStream, boolean explicit) throws IOException {
        int codeLength = 0;
        if (explicit) {
            codeLength += this.id.decodeAndCheck(iStream);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(iStream);
        if (length.val != 1) {
            throw new IOException("Decoded length of BerBoolean is not correct");
        }
        int readVal = iStream.read();
        this.val = readVal != 0;
        return ++codeLength;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        BerByteArrayOutputStream berOStream = new BerByteArrayOutputStream(encodingSizeGuess);
        this.encode(berOStream, false);
        this.code = berOStream.getArray();
    }
}

