/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerIdentifier;
import org.openmuc.jasn1.ber.BerLength;

public class BerInteger {
    public static final BerIdentifier identifier = new BerIdentifier(0, 0, 2);
    public BerIdentifier id = identifier;
    public byte[] code = null;
    public long val;

    public BerInteger() {
    }

    public BerInteger(byte[] code) {
        this.code = code;
    }

    public BerInteger(long val) {
        this.val = val;
    }

    public int encode(BerByteArrayOutputStream berOStream, boolean explicit) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                berOStream.write(this.code[i]);
            }
        } else {
            for (codeLength = 1; (double)this.val > Math.pow(2.0, 8 * codeLength - 1) - 1.0 || (double)this.val < Math.pow(-2.0, 8 * codeLength - 1) && codeLength < 8; ++codeLength) {
            }
            for (int i = 0; i < codeLength; ++i) {
                berOStream.write((int)(this.val >> 8 * i));
            }
            codeLength += BerLength.encodeLength(berOStream, codeLength);
        }
        if (explicit) {
            codeLength += this.id.encode(berOStream);
        }
        return codeLength;
    }

    public int decode(InputStream iStream, boolean explicit) throws IOException {
        int codeLength = 0;
        if (explicit) {
            codeLength += this.id.decodeAndCheck(iStream);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(iStream);
        if (length.val < 1 || length.val > 8) {
            throw new IOException("Decoded length of BerInteger is not correct");
        }
        byte[] byteCode = new byte[length.val];
        if (iStream.read(byteCode, 0, length.val) < length.val) {
            throw new IOException("Error Decoding BerInteger");
        }
        codeLength += length.val;
        this.val = (byteCode[0] & 0x80) == 128 ? -1L : 0L;
        for (int i = 0; i < length.val; ++i) {
            this.val <<= 8;
            this.val |= (long)(byteCode[i] & 0xFF);
        }
        return codeLength;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        BerByteArrayOutputStream berOStream = new BerByteArrayOutputStream(encodingSizeGuess);
        this.encode(berOStream, false);
        this.code = berOStream.getArray();
    }
}

