/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerIdentifier;
import org.openmuc.jasn1.ber.BerLength;

public class BerNull {
    public static final BerIdentifier identifier = new BerIdentifier(0, 0, 5);
    public BerIdentifier id = identifier;

    public int encode(BerByteArrayOutputStream berOStream, boolean explicit) throws IOException {
        int codeLength = BerLength.encodeLength(berOStream, 0);
        if (explicit) {
            codeLength += this.id.encode(berOStream);
        }
        return codeLength;
    }

    public int decode(InputStream iStream, boolean explicit) throws IOException {
        int codeLength = 0;
        if (explicit) {
            codeLength += this.id.decodeAndCheck(iStream);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(iStream);
        if (length.val != 0) {
            throw new IOException("Decoded length of BerNull is not correct");
        }
        return codeLength;
    }
}

