/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerIdentifier;
import org.openmuc.jasn1.ber.BerLength;

public class BerObjectIdentifier {
    public static final BerIdentifier identifier = new BerIdentifier(0, 0, 6);
    protected BerIdentifier id = identifier;
    public byte[] code = null;
    public int[] objectIdentifierComponents;

    public BerObjectIdentifier() {
    }

    public BerObjectIdentifier(byte[] code) {
        this.code = code;
    }

    public BerObjectIdentifier(int[] objectIdentifierComponents) {
        if (objectIdentifierComponents.length < 2 || (objectIdentifierComponents[0] == 0 || objectIdentifierComponents[0] == 1) && objectIdentifierComponents[1] > 39 || objectIdentifierComponents[0] > 2) {
            throw new IllegalArgumentException("invalid object identifier components");
        }
        for (int objectIdentifierComponent : objectIdentifierComponents) {
            if (objectIdentifierComponent >= 0) continue;
            throw new IllegalArgumentException("invalid object identifier components");
        }
        this.objectIdentifierComponents = objectIdentifierComponents;
    }

    public int encode(BerByteArrayOutputStream berOStream, boolean explicit) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                berOStream.write(this.code[i]);
            }
        } else {
            int firstSubidentifier = 40 * this.objectIdentifierComponents[0] + this.objectIdentifierComponents[1];
            codeLength = 0;
            for (int i = this.objectIdentifierComponents.length - 1; i > 0; --i) {
                int subidentifier = i == 1 ? firstSubidentifier : this.objectIdentifierComponents[i];
                int subIDLength = 1;
                while ((double)subidentifier > Math.pow(2.0, 7 * subIDLength) - 1.0) {
                    ++subIDLength;
                }
                berOStream.write(subidentifier & 0x7F);
                for (int j = 1; j <= subIDLength - 1; ++j) {
                    berOStream.write(subidentifier >> 7 * j & 0xFF | 0x80);
                }
                codeLength += subIDLength;
            }
            codeLength += BerLength.encodeLength(berOStream, codeLength);
        }
        if (explicit) {
            codeLength += this.id.encode(berOStream);
        }
        return codeLength;
    }

    public int decode(InputStream iStream, boolean explicit) throws IOException {
        int i;
        int codeLength = 0;
        if (explicit) {
            codeLength += this.id.decodeAndCheck(iStream);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(iStream);
        if (length.val == 0) {
            this.objectIdentifierComponents = new int[0];
            return codeLength;
        }
        byte[] byteCode = new byte[length.val];
        if (iStream.read(byteCode, 0, length.val) == -1) {
            throw new IOException("Error Decoding BerObjectIdentifier");
        }
        codeLength += length.val;
        ArrayList<Integer> objectIdentifierComponentsList = new ArrayList<Integer>();
        int subIDEndIndex = 0;
        while ((byteCode[subIDEndIndex] & 0x80) == 128) {
            if (subIDEndIndex >= length.val - 1) {
                throw new IOException("Invalid Object Identifier");
            }
            ++subIDEndIndex;
        }
        int subidentifier = 0;
        for (i = 0; i <= subIDEndIndex; ++i) {
            subidentifier |= byteCode[i] << (subIDEndIndex - i) * 7;
        }
        if (subidentifier < 40) {
            objectIdentifierComponentsList.add(0);
            objectIdentifierComponentsList.add(subidentifier);
        } else if (subidentifier < 80) {
            objectIdentifierComponentsList.add(1);
            objectIdentifierComponentsList.add(subidentifier - 40);
        } else {
            objectIdentifierComponentsList.add(2);
            objectIdentifierComponentsList.add(subidentifier - 80);
        }
        ++subIDEndIndex;
        while (subIDEndIndex < length.val) {
            int subIDStartIndex = subIDEndIndex;
            while ((byteCode[subIDEndIndex] & 0x80) == 128) {
                if (subIDEndIndex == length.val - 1) {
                    throw new IOException("Invalid Object Identifier");
                }
                ++subIDEndIndex;
            }
            subidentifier = 0;
            for (int j = subIDStartIndex; j <= subIDEndIndex; ++j) {
                subidentifier |= (byteCode[j] & 0x7F) << (subIDEndIndex - j) * 7;
            }
            objectIdentifierComponentsList.add(subidentifier);
            ++subIDEndIndex;
        }
        this.objectIdentifierComponents = new int[objectIdentifierComponentsList.size()];
        for (i = 0; i < objectIdentifierComponentsList.size(); ++i) {
            this.objectIdentifierComponents[i] = (Integer)objectIdentifierComponentsList.get(i);
        }
        return codeLength;
    }

    public String toString() {
        if (this.objectIdentifierComponents == null || this.objectIdentifierComponents.length == 0) {
            return "";
        }
        String objIDString = "";
        objIDString = objIDString + this.objectIdentifierComponents[0];
        for (int i = 1; i < this.objectIdentifierComponents.length; ++i) {
            objIDString = objIDString + "." + this.objectIdentifierComponents[i];
        }
        return objIDString;
    }
}

