/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerIdentifier;
import org.openmuc.jasn1.ber.BerLength;

public class BerOctetString {
    public static final BerIdentifier identifier = new BerIdentifier(0, 0, 4);
    protected BerIdentifier id = identifier;
    public byte[] octetString;

    public BerOctetString() {
    }

    public BerOctetString(byte[] octetString) {
        this.octetString = octetString;
    }

    public int encode(BerByteArrayOutputStream berOStream, boolean explicit) throws IOException {
        berOStream.write(this.octetString);
        int codeLength = this.octetString.length;
        codeLength += BerLength.encodeLength(berOStream, codeLength);
        if (explicit) {
            codeLength += this.id.encode(berOStream);
        }
        return codeLength;
    }

    public int decode(InputStream iStream, boolean explicit) throws IOException {
        int codeLength = 0;
        if (explicit) {
            codeLength += this.id.decodeAndCheck(iStream);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(iStream);
        this.octetString = new byte[length.val];
        if (length.val != 0) {
            if (iStream.read(this.octetString, 0, length.val) < length.val) {
                throw new IOException("Error Decoding BerOctetString");
            }
            codeLength += length.val;
        }
        return codeLength;
    }

    public String toString() {
        return new String(this.octetString);
    }
}

