/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerIdentifier;
import org.openmuc.jasn1.ber.BerLength;

public class BerReal {
    public static final BerIdentifier identifier = new BerIdentifier(0, 0, 9);
    public BerIdentifier id = identifier;
    public byte[] code = null;
    public double val;

    public BerReal() {
    }

    public BerReal(byte[] code) {
        this.code = code;
    }

    public BerReal(double val) {
        this.val = val;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int encode(BerByteArrayOutputStream berOStream, boolean explicit) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                berOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            Long longVal = Double.doubleToLongBits(this.val);
            int sign = 0;
            if (this.val < 0.0) {
                sign = 64;
            }
            byte exponentFormat = 0;
            int exponent = (int)(longVal >> 52) & 0x7FF;
            long mantissa = longVal & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            if (exponent == 2047) {
                if (mantissa != 0x10000000000000L) throw new IOException("NAN not supported");
                if (sign == 0) {
                    berOStream.write(64);
                } else {
                    berOStream.write(65);
                }
                ++codeLength;
            } else if (exponent != 0 || mantissa != 0x10000000000000L) {
                int expLength;
                exponent -= 1075;
                int exponentIncr = 0;
                while ((longVal >> exponentIncr & 0xFFL) == 0L) {
                    exponentIncr += 8;
                }
                while ((longVal >> exponentIncr & 1L) == 0L) {
                    ++exponentIncr;
                }
                exponent += exponentIncr;
                mantissa >>= exponentIncr;
                int mantissaLength = 1;
                while ((double)mantissa > Math.pow(2.0, 8 * mantissaLength - 1) - 1.0) {
                    ++mantissaLength;
                }
                for (int i = 0; i < mantissaLength; ++i) {
                    berOStream.write((int)(mantissa >> 8 * i) & 0xFF);
                }
                codeLength += mantissaLength;
                for (expLength = 1; (double)exponent > Math.pow(2.0, 8 * expLength - 1) - 1.0 || (double)exponent < Math.pow(-2.0, 8 * expLength - 1) && expLength < 8; ++expLength) {
                }
                for (int i = 0; i < expLength; ++i) {
                    berOStream.write(exponent >> 8 * i & 0xFF);
                }
                codeLength += expLength;
                if (expLength < 4) {
                    exponentFormat = (byte)(expLength - 1);
                } else {
                    berOStream.write(expLength);
                    ++codeLength;
                    exponentFormat = (byte)3;
                }
                berOStream.write(0x80 | sign | exponentFormat);
                ++codeLength;
            }
            codeLength += BerLength.encodeLength(berOStream, codeLength);
        }
        if (!explicit) return codeLength;
        codeLength += this.id.encode(berOStream);
        return codeLength;
    }

    public int decode(InputStream iStream, boolean explicit) throws IOException {
        int exponentLength;
        int codeLength = 0;
        if (explicit) {
            codeLength += this.id.decodeAndCheck(iStream);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(iStream);
        if (length.val == 0) {
            this.val = 0.0;
            return codeLength;
        }
        if (length.val == 1) {
            int myByte = iStream.read();
            if (myByte == 64) {
                this.val = Double.POSITIVE_INFINITY;
            } else if (myByte == 65) {
                this.val = Double.NEGATIVE_INFINITY;
            } else {
                throw new IOException("invalid real encoding");
            }
            return codeLength + 1;
        }
        byte[] byteCode = new byte[length.val];
        if (iStream.read(byteCode, 0, length.val) < length.val) {
            throw new IOException("Error Decoding BerInteger");
        }
        codeLength += length.val;
        int tempLength = 1;
        int sign = 1;
        if ((byteCode[0] & 0x40) == 64) {
            sign = -1;
        }
        if ((exponentLength = (byteCode[0] & 3) + 1) == 4) {
            exponentLength = byteCode[1];
            ++tempLength;
        }
        tempLength += exponentLength;
        int exponent = 0;
        for (int i = 0; i < exponentLength; ++i) {
            exponent |= byteCode[1 + i] << 8 * (exponentLength - i - 1);
        }
        int mantissa = 0;
        for (int i = 0; i < length.val - tempLength; ++i) {
            mantissa |= byteCode[i + tempLength] << 8 * (length.val - tempLength - i - 1);
        }
        this.val = (double)(sign * mantissa) * Math.pow(2.0, exponent);
        return codeLength;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        BerByteArrayOutputStream berOStream = new BerByteArrayOutputStream(encodingSizeGuess);
        this.encode(berOStream, false);
        this.code = berOStream.getArray();
    }
}

