/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerLength;
import org.openmuc.jasn1.ber.types.Util;

public class BerAny {
    public byte[] value;

    public BerAny() {
    }

    public BerAny(byte[] value) {
        this.value = value;
    }

    public int encode(BerByteArrayOutputStream os, boolean explicit) throws IOException {
        os.write(this.value);
        int codeLength = this.value.length;
        codeLength += BerLength.encodeLength(os, codeLength);
        return codeLength;
    }

    public int decode(InputStream is, boolean explicit) throws IOException {
        int codeLength = 0;
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        this.value = new byte[length.val];
        if (length.val != 0) {
            Util.readFully(is, this.value);
            codeLength += length.val;
        }
        return codeLength;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (byte element : this.value) {
            String hexString = Integer.toHexString(element & 0xFF);
            if (hexString.length() == 1) {
                builder.append("0");
            }
            builder.append(hexString);
        }
        return builder.toString();
    }
}

