/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerIdentifier;
import org.openmuc.jasn1.ber.BerLength;
import org.openmuc.jasn1.ber.types.Util;

public class BerBitString {
    public static final BerIdentifier identifier = new BerIdentifier(0, 0, 3);
    protected BerIdentifier id = identifier;
    public byte[] code = null;
    public byte[] value;
    public int numBits;

    public BerBitString() {
    }

    public BerBitString(byte[] value, int numBits) {
        if (numBits < (value.length - 1) * 8 + 1 || numBits > value.length * 8) {
            throw new IllegalArgumentException("numBits out of bound.");
        }
        this.value = value;
        this.numBits = numBits;
    }

    public BerBitString(byte[] code) {
        this.code = code;
    }

    public int encode(BerByteArrayOutputStream os, boolean explicit) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                os.write(this.code[i]);
            }
        } else {
            for (int i = this.value.length - 1; i >= 0; --i) {
                os.write(this.value[i]);
            }
            os.write(this.value.length * 8 - this.numBits);
            codeLength = this.value.length + 1;
            codeLength += BerLength.encodeLength(os, codeLength);
        }
        if (explicit) {
            codeLength += this.id.encode(os);
        }
        return codeLength;
    }

    public int decode(InputStream is, boolean explicit) throws IOException {
        int codeLength = 0;
        if (explicit) {
            codeLength += this.id.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        this.value = new byte[length.val - 1];
        int nextByte = is.read();
        if (nextByte == -1) {
            throw new EOFException("Unexpected end of input stream.");
        }
        this.numBits = this.value.length * 8 - nextByte;
        if (this.value.length > 0) {
            Util.readFully(is, this.value);
        }
        return codeLength += this.value.length + 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numBits; ++i) {
            if ((this.value[i / 8] & 0xFF & 128 >> i % 8) == 128 >> i % 8) {
                sb.append('1');
                continue;
            }
            sb.append('0');
        }
        return sb.toString();
    }
}

