/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerIdentifier;
import org.openmuc.jasn1.ber.BerLength;
import org.openmuc.jasn1.ber.types.Util;

public class BerInteger {
    public static final BerIdentifier identifier = new BerIdentifier(0, 0, 2);
    public BerIdentifier id = identifier;
    public byte[] code = null;
    public long value;

    public BerInteger() {
    }

    public BerInteger(byte[] code) {
        this.code = code;
    }

    public BerInteger(long val) {
        this.value = val;
    }

    public int encode(BerByteArrayOutputStream os, boolean explicit) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                os.write(this.code[i]);
            }
        } else {
            for (codeLength = 1; (double)this.value > Math.pow(2.0, 8 * codeLength - 1) - 1.0 || (double)this.value < Math.pow(-2.0, 8 * codeLength - 1) && codeLength < 8; ++codeLength) {
            }
            for (int i = 0; i < codeLength; ++i) {
                os.write((int)(this.value >> 8 * i));
            }
            codeLength += BerLength.encodeLength(os, codeLength);
        }
        if (explicit) {
            codeLength += this.id.encode(os);
        }
        return codeLength;
    }

    public int decode(InputStream is, boolean explicit) throws IOException {
        int codeLength = 0;
        if (explicit) {
            codeLength += this.id.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        if (length.val < 1 || length.val > 8) {
            throw new IOException("Decoded length of BerInteger is not correct");
        }
        byte[] byteCode = new byte[length.val];
        Util.readFully(is, byteCode);
        codeLength += length.val;
        this.value = (byteCode[0] & 0x80) == 128 ? -1L : 0L;
        for (int i = 0; i < length.val; ++i) {
            this.value <<= 8;
            this.value |= (long)(byteCode[i] & 0xFF);
        }
        return codeLength;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        BerByteArrayOutputStream os = new BerByteArrayOutputStream(encodingSizeGuess);
        this.encode(os, false);
        this.code = os.getArray();
    }

    public String toString() {
        return "" + this.value;
    }
}

