/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerIdentifier;
import org.openmuc.jasn1.ber.BerLength;
import org.openmuc.jasn1.ber.types.Util;

public class BerOctetString {
    public static final BerIdentifier identifier = new BerIdentifier(0, 0, 4);
    protected BerIdentifier id = identifier;
    public byte[] value;

    public BerOctetString() {
    }

    public BerOctetString(byte[] value) {
        this.value = value;
    }

    public int encode(BerByteArrayOutputStream os, boolean explicit) throws IOException {
        os.write(this.value);
        int codeLength = this.value.length;
        codeLength += BerLength.encodeLength(os, codeLength);
        if (explicit) {
            codeLength += this.id.encode(os);
        }
        return codeLength;
    }

    public int decode(InputStream is, boolean explicit) throws IOException {
        int codeLength = 0;
        if (explicit) {
            codeLength += this.id.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        this.value = new byte[length.val];
        if (length.val != 0) {
            Util.readFully(is, this.value);
            codeLength += length.val;
        }
        return codeLength;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (byte element : this.value) {
            String hexString = Integer.toHexString(element & 0xFF);
            if (hexString.length() == 1) {
                builder.append("0");
            }
            builder.append(hexString);
        }
        return builder.toString();
    }
}

