/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;

public class BerLength {
    public int val;

    public int decode(InputStream is) throws IOException {
        this.val = is.read();
        if (this.val == -1) {
            throw new EOFException("Unexpected end of input stream.");
        }
        int length = 1;
        if ((this.val & 0x80) != 0) {
            int lengthLength = this.val & 0x7F;
            if (lengthLength == 0) {
                this.val = -1;
                return 1;
            }
            if (lengthLength > 4) {
                throw new IOException("Length is out of bound!");
            }
            this.val = 0;
            length += lengthLength;
            for (int i = 0; i < lengthLength; ++i) {
                int nextByte = is.read();
                if (nextByte == -1) {
                    throw new EOFException("Unexpected end of input stream.");
                }
                this.val |= nextByte << 8 * (lengthLength - i - 1);
            }
        }
        return length;
    }

    public static int encodeLength(BerByteArrayOutputStream os, int length) throws IOException {
        if (length <= 127) {
            os.write((byte)length);
            return 1;
        }
        int numLengthBytes = 1;
        while ((int)(Math.pow(2.0, 8 * numLengthBytes) - 1.0) < length) {
            ++numLengthBytes;
        }
        for (int i = 0; i < numLengthBytes; ++i) {
            os.write(length >> 8 * i & 0xFF);
        }
        os.write(0x80 | numLengthBytes);
        return 1 + numLengthBytes;
    }
}

