/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerIdentifier;
import org.openmuc.jasn1.ber.BerLength;

public class BerBoolean {
    public static final BerIdentifier identifier = new BerIdentifier(0, 0, 1);
    public BerIdentifier id = identifier;
    public byte[] code = null;
    public boolean value;

    public BerBoolean() {
    }

    public BerBoolean(byte[] code) {
        this.code = code;
    }

    public BerBoolean(boolean value) {
        this.value = value;
    }

    public int encode(BerByteArrayOutputStream os, boolean explicit) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                os.write(this.code[i]);
            }
        } else {
            codeLength = 1;
            if (this.value) {
                os.write(255);
            } else {
                os.write(0);
            }
            codeLength += BerLength.encodeLength(os, codeLength);
        }
        if (explicit) {
            codeLength += this.id.encode(os);
        }
        return codeLength;
    }

    public int decode(InputStream is, boolean explicit) throws IOException {
        int codeLength = 0;
        if (explicit) {
            codeLength += this.id.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        if (length.val != 1) {
            throw new IOException("Decoded length of BerBoolean is not correct");
        }
        int nextByte = is.read();
        if (nextByte == -1) {
            throw new EOFException("Unexpected end of input stream.");
        }
        this.value = nextByte != 0;
        return ++codeLength;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        BerByteArrayOutputStream os = new BerByteArrayOutputStream(encodingSizeGuess);
        this.encode(os, false);
        this.code = os.getArray();
    }

    public String toString() {
        return "" + this.value;
    }
}

