/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerIdentifier;
import org.openmuc.jasn1.ber.BerLength;
import org.openmuc.jasn1.ber.types.Util;

public class BerReal {
    public static final BerIdentifier identifier = new BerIdentifier(0, 0, 9);
    public BerIdentifier id = identifier;
    public byte[] code = null;
    public double value;

    public BerReal() {
    }

    public BerReal(byte[] code) {
        this.code = code;
    }

    public BerReal(double value) {
        this.value = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int encode(BerByteArrayOutputStream os, boolean explicit) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                os.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            Long longVal = Double.doubleToLongBits(this.value);
            int sign = 0;
            if (this.value < 0.0) {
                sign = 64;
            }
            byte exponentFormat = 0;
            int exponent = (int)(longVal >> 52) & 0x7FF;
            long mantissa = longVal & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            if (exponent == 2047) {
                if (mantissa != 0x10000000000000L) throw new IOException("NAN not supported");
                if (sign == 0) {
                    os.write(64);
                } else {
                    os.write(65);
                }
                ++codeLength;
            } else if (exponent != 0 || mantissa != 0x10000000000000L) {
                int expLength;
                exponent -= 1075;
                int exponentIncr = 0;
                while ((longVal >> exponentIncr & 0xFFL) == 0L) {
                    exponentIncr += 8;
                }
                while ((longVal >> exponentIncr & 1L) == 0L) {
                    ++exponentIncr;
                }
                exponent += exponentIncr;
                mantissa >>= exponentIncr;
                int mantissaLength = 1;
                while ((double)mantissa > Math.pow(2.0, 8 * mantissaLength - 1) - 1.0) {
                    ++mantissaLength;
                }
                for (int i = 0; i < mantissaLength; ++i) {
                    os.write((int)(mantissa >> 8 * i) & 0xFF);
                }
                codeLength += mantissaLength;
                for (expLength = 1; (double)exponent > Math.pow(2.0, 8 * expLength - 1) - 1.0 || (double)exponent < Math.pow(-2.0, 8 * expLength - 1) && expLength < 8; ++expLength) {
                }
                for (int i = 0; i < expLength; ++i) {
                    os.write(exponent >> 8 * i & 0xFF);
                }
                codeLength += expLength;
                if (expLength < 4) {
                    exponentFormat = (byte)(expLength - 1);
                } else {
                    os.write(expLength);
                    ++codeLength;
                    exponentFormat = (byte)3;
                }
                os.write(0x80 | sign | exponentFormat);
                ++codeLength;
            }
            codeLength += BerLength.encodeLength(os, codeLength);
        }
        if (!explicit) return codeLength;
        codeLength += this.id.encode(os);
        return codeLength;
    }

    public int decode(InputStream is, boolean explicit) throws IOException {
        int exponentLength;
        int codeLength = 0;
        if (explicit) {
            codeLength += this.id.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        if (length.val == 0) {
            this.value = 0.0;
            return codeLength;
        }
        if (length.val == 1) {
            int nextByte = is.read();
            if (nextByte == -1) {
                throw new EOFException("Unexpected end of input stream.");
            }
            if (nextByte == 64) {
                this.value = Double.POSITIVE_INFINITY;
            } else if (nextByte == 65) {
                this.value = Double.NEGATIVE_INFINITY;
            } else {
                throw new IOException("invalid real encoding");
            }
            return codeLength + 1;
        }
        byte[] byteCode = new byte[length.val];
        Util.readFully(is, byteCode);
        codeLength += length.val;
        int tempLength = 1;
        int sign = 1;
        if ((byteCode[0] & 0x40) == 64) {
            sign = -1;
        }
        if ((exponentLength = (byteCode[0] & 3) + 1) == 4) {
            exponentLength = byteCode[1];
            ++tempLength;
        }
        tempLength += exponentLength;
        int exponent = 0;
        for (int i = 0; i < exponentLength; ++i) {
            exponent |= byteCode[1 + i] << 8 * (exponentLength - i - 1);
        }
        int mantissa = 0;
        for (int i = 0; i < length.val - tempLength; ++i) {
            mantissa |= byteCode[i + tempLength] << 8 * (length.val - tempLength - i - 1);
        }
        this.value = (double)(sign * mantissa) * Math.pow(2.0, exponent);
        return codeLength;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        BerByteArrayOutputStream os = new BerByteArrayOutputStream(encodingSizeGuess);
        this.encode(os, false);
        this.code = os.getArray();
    }

    public String toString() {
        return "" + this.value;
    }
}

