/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types.string;

import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerIdentifier;
import org.openmuc.jasn1.ber.BerLength;

public class BerVisibleString {
    public static final BerIdentifier identifier = new BerIdentifier(0, 0, 26);
    protected BerIdentifier id = identifier;
    public byte[] value;

    public BerVisibleString() {
    }

    public BerVisibleString(byte[] value) {
        this.value = value;
    }

    public BerVisibleString(String valueAsString) {
        this.value = valueAsString.getBytes();
    }

    public int encode(BerByteArrayOutputStream os, boolean explicit) throws IOException {
        os.write(this.value);
        int codeLength = this.value.length;
        codeLength += BerLength.encodeLength(os, codeLength);
        if (explicit) {
            codeLength += this.id.encode(os);
        }
        return codeLength;
    }

    public int decode(InputStream is, boolean explicit) throws IOException {
        int codeLength = 0;
        if (explicit) {
            codeLength += this.id.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        this.value = new byte[length.val];
        if (length.val != 0) {
            if (is.read(this.value, 0, length.val) < length.val) {
                throw new IOException("Error Decoding BerVisibleString");
            }
            codeLength += length.val;
        }
        return codeLength;
    }

    public String toString() {
        return new String(this.value);
    }
}

