/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerLength;
import org.openmuc.jasn1.ber.BerTag;
import org.openmuc.jasn1.ber.types.Util;

public class BerOctetString {
    public static final BerTag tag = new BerTag(0, 0, 4);
    public byte[] value;

    public BerOctetString() {
    }

    public BerOctetString(byte[] value) {
        this.value = value;
    }

    public int encode(BerByteArrayOutputStream os) throws IOException {
        return this.encode(os, true);
    }

    public int encode(BerByteArrayOutputStream os, boolean withTag) throws IOException {
        os.write(this.value);
        int codeLength = this.value.length;
        codeLength += BerLength.encodeLength(os, codeLength);
        if (withTag) {
            codeLength += tag.encode(os);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        this.value = new byte[length.val];
        if (length.val != 0) {
            Util.readFully(is, this.value);
            codeLength += length.val;
        }
        return codeLength;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (byte element : this.value) {
            String hexString = Integer.toHexString(element & 0xFF);
            if (hexString.length() == 1) {
                builder.append("0");
            }
            builder.append(hexString);
        }
        return builder.toString();
    }
}

