/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types.string;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerTag;
import org.openmuc.jasn1.ber.types.BerOctetString;

public class BerUTF8String
extends BerOctetString {
    public static final BerTag tag = new BerTag(0, 0, 12);

    public BerUTF8String() {
    }

    public BerUTF8String(byte[] value) {
        this.value = value;
    }

    public BerUTF8String(String valueAsString) throws UnsupportedEncodingException {
        this.value = valueAsString.getBytes("UTF-8");
    }

    @Override
    public String toString() {
        try {
            return new String(this.value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "Unsupported Encoding";
        }
    }

    @Override
    public int encode(BerByteArrayOutputStream os, boolean withTag) throws IOException {
        int codeLength = super.encode(os, false);
        if (withTag) {
            codeLength += tag.encode(os);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        return codeLength += super.decode(is, false);
    }
}

