/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types.string;

import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerLength;
import org.openmuc.jasn1.ber.BerTag;

public class BerVisibleString {
    public static final BerTag tag = new BerTag(0, 0, 26);
    public byte[] value;

    public BerVisibleString() {
    }

    public BerVisibleString(byte[] value) {
        this.value = value;
    }

    public BerVisibleString(String valueAsString) {
        this.value = valueAsString.getBytes();
    }

    public int encode(BerByteArrayOutputStream os) throws IOException {
        return this.encode(os, true);
    }

    public int encode(BerByteArrayOutputStream os, boolean withTag) throws IOException {
        os.write(this.value);
        int codeLength = this.value.length;
        codeLength += BerLength.encodeLength(os, codeLength);
        if (withTag) {
            codeLength += tag.encode(os);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        this.value = new byte[length.val];
        if (length.val != 0) {
            if (is.read(this.value, 0, length.val) < length.val) {
                throw new IOException("Error Decoding BerVisibleString");
            }
            codeLength += length.val;
        }
        return codeLength;
    }

    public String toString() {
        return new String(this.value);
    }
}

