/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerLength;
import org.openmuc.jasn1.ber.BerTag;
import org.openmuc.jasn1.ber.types.Util;

public class BerBitString {
    public static final BerTag tag = new BerTag(0, 0, 3);
    public byte[] code = null;
    public byte[] value;
    public int numBits;

    public BerBitString() {
    }

    public BerBitString(byte[] value, int numBits) {
        if (numBits < (value.length - 1) * 8 + 1 || numBits > value.length * 8) {
            throw new IllegalArgumentException("numBits out of bound.");
        }
        this.value = value;
        this.numBits = numBits;
    }

    public BerBitString(byte[] code) {
        this.code = code;
    }

    public int encode(BerByteArrayOutputStream os) throws IOException {
        return this.encode(os, true);
    }

    public int encode(BerByteArrayOutputStream os, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                os.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(os) + this.code.length;
            }
            return this.code.length;
        }
        for (int i = this.value.length - 1; i >= 0; --i) {
            os.write(this.value[i]);
        }
        os.write(this.value.length * 8 - this.numBits);
        int codeLength = this.value.length + 1;
        codeLength += BerLength.encodeLength(os, codeLength);
        if (withTag) {
            codeLength += tag.encode(os);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        this.value = new byte[length.val - 1];
        int nextByte = is.read();
        if (nextByte == -1) {
            throw new EOFException("Unexpected end of input stream.");
        }
        this.numBits = this.value.length * 8 - nextByte;
        if (this.value.length > 0) {
            Util.readFully(is, this.value);
        }
        return codeLength += this.value.length + 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numBits; ++i) {
            if ((this.value[i / 8] & 0xFF & 128 >> i % 8) == 128 >> i % 8) {
                sb.append('1');
                continue;
            }
            sb.append('0');
        }
        return sb.toString();
    }
}

