/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerLength;
import org.openmuc.jasn1.ber.BerTag;
import org.openmuc.jasn1.ber.internal.Util;
import org.openmuc.jasn1.util.HexConverter;

public class BerAny
implements Serializable {
    private static final long serialVersionUID = 1L;
    public byte[] value;

    public BerAny() {
    }

    public BerAny(byte[] value) {
        this.value = value;
    }

    public int encode(BerByteArrayOutputStream os) throws IOException {
        os.write(this.value);
        return this.value.length;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag tag) throws IOException {
        int tagLength;
        int decodedLength = 0;
        if (tag == null) {
            tag = new BerTag();
            tagLength = tag.decode(is);
            decodedLength += tagLength;
        } else {
            tagLength = tag.encode(new BerByteArrayOutputStream(10));
        }
        BerLength lengthField = new BerLength();
        int lengthLength = lengthField.decode(is);
        decodedLength += lengthLength + lengthField.val;
        this.value = new byte[tagLength + lengthLength + lengthField.val];
        Util.readFully(is, this.value, tagLength + lengthLength, lengthField.val);
        BerByteArrayOutputStream os = new BerByteArrayOutputStream(this.value, tagLength + lengthLength - 1);
        BerLength.encodeLength(os, lengthField.val);
        tag.encode(os);
        return decodedLength;
    }

    public String toString() {
        return HexConverter.toShortHexString(this.value);
    }
}

