/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerTag;
import org.openmuc.jasn1.ber.types.string.BerVisibleString;

public class BerGeneralizedTime
extends BerVisibleString {
    private static final long serialVersionUID = 1L;
    public static final BerTag tag = new BerTag(0, 0, 24);
    private static final String GENERALIZED_TIME_PATTERN = "^(?<year>\\d{4})(?<month>\\d{2})(?<day>\\d{2})(?<hour>\\d{2})((?<minute>\\d{2})(?<second>\\d{2})?)?([.,](?<frac>\\d+))?(?<timezone>Z|([+-]\\d{2}(?<tzmin>\\d{2})?))?$";
    private static final Pattern generalizedTimePattern = Pattern.compile("^(?<year>\\d{4})(?<month>\\d{2})(?<day>\\d{2})(?<hour>\\d{2})((?<minute>\\d{2})(?<second>\\d{2})?)?([.,](?<frac>\\d+))?(?<timezone>Z|([+-]\\d{2}(?<tzmin>\\d{2})?))?$");

    public BerGeneralizedTime() {
    }

    public BerGeneralizedTime(byte[] value) {
        super(value);
    }

    public BerGeneralizedTime(String valueAsString) {
        super(valueAsString);
    }

    @Override
    public int encode(BerByteArrayOutputStream os, boolean withTag) throws IOException {
        int codeLength = super.encode(os, false);
        if (withTag) {
            codeLength += tag.encode(os);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        return codeLength += super.decode(is, false);
    }

    Calendar asCalendar() throws ParseException {
        double frac;
        Matcher matcher = generalizedTimePattern.matcher(this.toString());
        if (!matcher.find()) {
            throw new ParseException("", 0);
        }
        int year = Integer.valueOf(matcher.group("year"));
        int month = Integer.valueOf(matcher.group("month"));
        --month;
        int day = Integer.valueOf(matcher.group("day"));
        int hour = Integer.valueOf(matcher.group("hour"));
        String mg = matcher.group("minute");
        String mgf = matcher.group("frac");
        int minute = 0;
        int second = 0;
        int millisec = 0;
        double d = frac = mgf == null ? 0.0 : Double.valueOf("0." + mgf);
        if (mg == null) {
            if (mgf != null) {
                millisec = (int)Math.round(3600000.0 * frac);
            }
        } else {
            minute = Integer.valueOf(mg);
            mg = matcher.group("second");
            if (mg == null) {
                if (mgf != null) {
                    millisec = (int)Math.round(60000.0 * frac);
                }
            } else {
                second = Integer.valueOf(mg);
                if (mgf != null) {
                    millisec = (int)Math.round(1000.0 * frac);
                }
            }
        }
        mg = matcher.group("timezone");
        String mgt = matcher.group("tzmin");
        String timeZoneStr = mg == null ? TimeZone.getDefault().getID() : (mg.equals("Z") ? "UTC" : (mgt == null ? "GMT" + mg + "00" : "GMT" + mg));
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneStr);
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(true);
        calendar.set(year, month, day, hour, minute, second);
        calendar.set(14, millisec);
        calendar.setTimeZone(timeZone);
        return calendar;
    }

    Date asDate() throws ParseException {
        return this.asCalendar().getTime();
    }
}

