/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerLength;
import org.openmuc.jasn1.ber.BerTag;
import org.openmuc.jasn1.ber.internal.Util;

public class BerInteger
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final BerTag tag = new BerTag(0, 0, 2);
    public byte[] code = null;
    public BigInteger value;

    public BerInteger() {
    }

    public BerInteger(byte[] code) {
        this.code = code;
    }

    public BerInteger(BigInteger val) {
        this.value = val;
    }

    public BerInteger(long val) {
        this.value = BigInteger.valueOf(val);
    }

    public int encode(BerByteArrayOutputStream os) throws IOException {
        return this.encode(os, true);
    }

    public int encode(BerByteArrayOutputStream os, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                os.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(os) + this.code.length;
            }
            return this.code.length;
        }
        byte[] encoded = this.value.toByteArray();
        int codeLength = encoded.length;
        os.write(encoded);
        codeLength += BerLength.encodeLength(os, codeLength);
        if (withTag) {
            codeLength += tag.encode(os);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        if (length.val < 1) {
            throw new IOException("Decoded length of BerInteger is not correct");
        }
        byte[] byteCode = new byte[length.val];
        Util.readFully(is, byteCode);
        this.value = new BigInteger(byteCode);
        return codeLength += length.val;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        BerByteArrayOutputStream os = new BerByteArrayOutputStream(encodingSizeGuess);
        this.encode(os, false);
        this.code = os.getArray();
    }

    public String toString() {
        return "" + this.value;
    }

    public byte byteValue() {
        return this.value.byteValue();
    }

    public short shortValue() {
        return this.value.shortValue();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }
}

