/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.openmuc.jasn1.ber.BerByteArrayOutputStream;
import org.openmuc.jasn1.ber.BerLength;
import org.openmuc.jasn1.ber.BerTag;
import org.openmuc.jasn1.ber.internal.Util;

public class BerObjectIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final BerTag tag = new BerTag(0, 0, 6);
    public byte[] code = null;
    public int[] value;

    public BerObjectIdentifier() {
    }

    public BerObjectIdentifier(byte[] code) {
        this.code = code;
    }

    public BerObjectIdentifier(int[] value) {
        if (value.length < 2 || (value[0] == 0 || value[0] == 1) && value[1] > 39 || value[0] > 2) {
            throw new IllegalArgumentException("invalid object identifier components");
        }
        for (int objectIdentifierComponent : value) {
            if (objectIdentifierComponent >= 0) continue;
            throw new IllegalArgumentException("invalid object identifier components");
        }
        this.value = value;
    }

    public int encode(BerByteArrayOutputStream os) throws IOException {
        return this.encode(os, true);
    }

    public int encode(BerByteArrayOutputStream os, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                os.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(os) + this.code.length;
            }
            return this.code.length;
        }
        int firstSubidentifier = 40 * this.value[0] + this.value[1];
        int codeLength = 0;
        for (int i = this.value.length - 1; i > 0; --i) {
            int subidentifier = i == 1 ? firstSubidentifier : this.value[i];
            int subIDLength = 1;
            while ((double)subidentifier > Math.pow(2.0, 7 * subIDLength) - 1.0) {
                ++subIDLength;
            }
            os.write(subidentifier & 0x7F);
            for (int j = 1; j <= subIDLength - 1; ++j) {
                os.write(subidentifier >> 7 * j & 0xFF | 0x80);
            }
            codeLength += subIDLength;
        }
        codeLength += BerLength.encodeLength(os, codeLength);
        if (withTag) {
            codeLength += tag.encode(os);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int i;
        int codeLength = 0;
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        if (length.val == 0) {
            this.value = new int[0];
            return codeLength;
        }
        byte[] byteCode = new byte[length.val];
        Util.readFully(is, byteCode);
        codeLength += length.val;
        ArrayList<Integer> objectIdentifierComponentsList = new ArrayList<Integer>();
        int subIDEndIndex = 0;
        while ((byteCode[subIDEndIndex] & 0x80) == 128) {
            if (subIDEndIndex >= length.val - 1) {
                throw new IOException("Invalid Object Identifier");
            }
            ++subIDEndIndex;
        }
        int subidentifier = 0;
        for (i = 0; i <= subIDEndIndex; ++i) {
            subidentifier |= byteCode[i] << (subIDEndIndex - i) * 7;
        }
        if (subidentifier < 40) {
            objectIdentifierComponentsList.add(0);
            objectIdentifierComponentsList.add(subidentifier);
        } else if (subidentifier < 80) {
            objectIdentifierComponentsList.add(1);
            objectIdentifierComponentsList.add(subidentifier - 40);
        } else {
            objectIdentifierComponentsList.add(2);
            objectIdentifierComponentsList.add(subidentifier - 80);
        }
        ++subIDEndIndex;
        while (subIDEndIndex < length.val) {
            int subIDStartIndex = subIDEndIndex;
            while ((byteCode[subIDEndIndex] & 0x80) == 128) {
                if (subIDEndIndex == length.val - 1) {
                    throw new IOException("Invalid Object Identifier");
                }
                ++subIDEndIndex;
            }
            subidentifier = 0;
            for (int j = subIDStartIndex; j <= subIDEndIndex; ++j) {
                subidentifier |= (byteCode[j] & 0x7F) << (subIDEndIndex - j) * 7;
            }
            objectIdentifierComponentsList.add(subidentifier);
            ++subIDEndIndex;
        }
        this.value = new int[objectIdentifierComponentsList.size()];
        for (i = 0; i < objectIdentifierComponentsList.size(); ++i) {
            this.value[i] = (Integer)objectIdentifierComponentsList.get(i);
        }
        return codeLength;
    }

    public String toString() {
        if (this.value == null || this.value.length == 0) {
            return "";
        }
        String objIDString = "";
        objIDString = objIDString + this.value[0];
        for (int i = 1; i < this.value.length; ++i) {
            objIDString = objIDString + "." + this.value[i];
        }
        return objIDString;
    }

    public BerObjectIdentifier append(int value) {
        if (this.value == null) {
            return new BerObjectIdentifier(new int[]{value});
        }
        int[] values = new int[this.value.length + 1];
        for (int i = 0; i < this.value.length; ++i) {
            values[i] = this.value[i];
        }
        values[values.length - 1] = value;
        return new BerObjectIdentifier(values);
    }
}

