/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.datasource.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ResourceKey {
    private final List<String> tokens;

    public static ResourceKey key(String ... tokens) {
        return new ResourceKey(tokens);
    }

    public static ResourceKey key(List<String> tokens) {
        return new ResourceKey(tokens);
    }

    public ResourceKey(List<String> tokens) {
        this.tokens = new ArrayList<String>(tokens);
    }

    public ResourceKey(String ... tokens) {
        this.tokens = Arrays.asList(tokens);
    }

    public List<String> getTokens() {
        return new ArrayList<String>(this.tokens);
    }

    public ResourceKey getParentKey() {
        if (this.tokens.size() < 1) {
            return this;
        }
        return ResourceKey.key(this.tokens.subList(0, this.tokens.size() - 1));
    }

    public int length() {
        return this.tokens.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceKey that = (ResourceKey)o;
        return Objects.equals(this.tokens, that.tokens);
    }

    public int hashCode() {
        return Objects.hash(this.tokens);
    }

    public String toString() {
        return this.tokens.toString();
    }
}

