/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.datasource.common;

import java.util.Objects;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.datasource.api.Severity;

public final class ImmutableAlarm
implements Alarm {
    private final String id;
    private final long time;
    private final Severity severity;
    private final String inventoryObjectId;
    private final String inventoryObjectType;
    private final String summary;
    private final String description;
    private final Long nodeId;

    private ImmutableAlarm(Builder builder) {
        this.id = builder.id;
        this.time = builder.time;
        this.severity = builder.severity;
        this.inventoryObjectId = builder.inventoryObjectId;
        this.inventoryObjectType = builder.inventoryObjectType;
        this.summary = builder.summary;
        this.description = builder.description;
        this.nodeId = builder.nodeId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(Alarm alarm) {
        return new Builder(alarm);
    }

    public String getId() {
        return this.id;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isClear() {
        return Severity.CLEARED == this.severity;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getInventoryObjectId() {
        return this.inventoryObjectId;
    }

    public String getInventoryObjectType() {
        return this.inventoryObjectType;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAlarm that = (ImmutableAlarm)o;
        return this.time == that.time && Objects.equals(this.id, that.id) && this.severity == that.severity && Objects.equals(this.inventoryObjectId, that.inventoryObjectId) && Objects.equals(this.inventoryObjectType, that.inventoryObjectType) && Objects.equals(this.summary, that.summary) && Objects.equals(this.description, that.description) && Objects.equals(this.nodeId, that.nodeId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.time, this.severity, this.inventoryObjectId, this.inventoryObjectType, this.summary, this.description, this.nodeId);
    }

    public String toString() {
        return "ImmutableAlarm{id='" + this.id + '\'' + ", time=" + this.time + ", severity=" + this.severity + ", inventoryObjectId='" + this.inventoryObjectId + '\'' + ", inventoryObjectType='" + this.inventoryObjectType + '\'' + ", summary='" + this.summary + '\'' + ", description='" + this.description + '\'' + ", nodeId=" + this.nodeId + '}';
    }

    public static final class Builder {
        private String id;
        private long time;
        private Severity severity;
        private String inventoryObjectId;
        private String inventoryObjectType;
        private String summary;
        private String description;
        private Long nodeId;

        private Builder() {
            this.time = System.currentTimeMillis();
        }

        private Builder(Alarm alarm) {
            this.id = alarm.getId();
            this.time = alarm.getTime();
            this.severity = alarm.getSeverity();
            this.inventoryObjectId = alarm.getInventoryObjectId();
            this.inventoryObjectType = alarm.getInventoryObjectType();
            this.summary = alarm.getSummary();
            this.description = alarm.getDescription();
            this.nodeId = alarm.getNodeId();
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setTime(long time) {
            this.time = time;
            return this;
        }

        public Builder setSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder setInventoryObjectId(String inventoryObjectId) {
            this.inventoryObjectId = inventoryObjectId;
            return this;
        }

        public Builder setInventoryObjectType(String inventoryObjectType) {
            this.inventoryObjectType = inventoryObjectType;
            return this;
        }

        public Builder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public void setNodeId(Long nodeId) {
            this.nodeId = nodeId;
        }

        public ImmutableAlarm build() {
            Objects.requireNonNull(this.id, "Id cannot be null");
            return new ImmutableAlarm(this);
        }
    }
}

