/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.datasource.common;

import java.util.Objects;
import org.opennms.alec.datasource.api.InventoryObjectRelativeRef;

public final class ImmutableInventoryObjectRelativeRef
implements InventoryObjectRelativeRef {
    private final String type;
    private final String id;
    private final long weight;

    private ImmutableInventoryObjectRelativeRef(Builder builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.weight = builder.weight;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(InventoryObjectRelativeRef inventoryObjectRelativeRef) {
        return new Builder(inventoryObjectRelativeRef);
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public long getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableInventoryObjectRelativeRef that = (ImmutableInventoryObjectRelativeRef)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id);
    }

    public String toString() {
        return "ImmutableInventoryObjectRelativeRef{type='" + this.type + '\'' + ", id='" + this.id + '\'' + ", weight=" + this.weight + '}';
    }

    public static final class Builder {
        private String type;
        private String id;
        private long weight;

        private Builder() {
            this.weight = 100L;
        }

        private Builder(InventoryObjectRelativeRef inventoryObjectRelativeRef) {
            this.type = inventoryObjectRelativeRef.getType();
            this.id = inventoryObjectRelativeRef.getId();
            this.weight = inventoryObjectRelativeRef.getWeight();
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setWeight(long weight) {
            this.weight = weight;
            return this;
        }

        public ImmutableInventoryObjectRelativeRef build() {
            Objects.requireNonNull(this.id, "Id cannot be null");
            Objects.requireNonNull(this.type, "Type cannot be null");
            return new ImmutableInventoryObjectRelativeRef(this);
        }
    }
}

