/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.datasource.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.alec.datasource.api.InventoryObject;
import org.opennms.alec.datasource.api.InventoryObjectPeerRef;
import org.opennms.alec.datasource.api.InventoryObjectRelativeRef;
import org.opennms.alec.datasource.common.ImmutableInventoryObjectPeerRef;
import org.opennms.alec.datasource.common.ImmutableInventoryObjectRelativeRef;

public final class ImmutableInventoryObject
implements InventoryObject {
    private final String type;
    private final String id;
    private final String parentType;
    private final String parentId;
    private final String subtype;
    private final String friendlyName;
    private final boolean isTopLevel;
    private final List<InventoryObjectPeerRef> peers;
    private final List<InventoryObjectRelativeRef> relatives;
    private final long weightToParent;

    private ImmutableInventoryObject(Builder builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.parentType = builder.parentType;
        this.parentId = builder.parentId;
        this.subtype = builder.subtype;
        this.friendlyName = builder.friendlyName;
        this.isTopLevel = builder.isTopLevel;
        this.peers = builder.peers == null ? Collections.emptyList() : Collections.unmodifiableList(this.copyPeers(builder.peers));
        this.relatives = builder.relatives == null ? Collections.emptyList() : Collections.unmodifiableList(this.copyRelatives(builder.relatives));
        this.weightToParent = builder.weightToParent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(InventoryObject inventoryObject) {
        return new Builder(inventoryObject);
    }

    private List<InventoryObjectPeerRef> copyPeers(List<InventoryObjectPeerRef> peers) {
        return peers.stream().map(peer -> {
            if (!(peer instanceof ImmutableInventoryObjectPeerRef)) {
                return ImmutableInventoryObjectPeerRef.newBuilderFrom(peer).build();
            }
            return peer;
        }).collect(Collectors.toList());
    }

    private List<InventoryObjectRelativeRef> copyRelatives(List<InventoryObjectRelativeRef> relatives) {
        return relatives.stream().map(relative -> {
            if (!(relative instanceof ImmutableInventoryObjectRelativeRef)) {
                return ImmutableInventoryObjectRelativeRef.newBuilderFrom(relative).build();
            }
            return relative;
        }).collect(Collectors.toList());
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getParentType() {
        return this.parentType;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    public List<InventoryObjectPeerRef> getPeers() {
        return this.peers;
    }

    public List<InventoryObjectRelativeRef> getRelatives() {
        return this.relatives;
    }

    public long getWeightToParent() {
        return this.weightToParent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableInventoryObject that = (ImmutableInventoryObject)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.id, that.id) && Objects.equals(this.parentType, that.parentType) && Objects.equals(this.parentId, that.parentId) && Objects.equals(this.friendlyName, that.friendlyName) && Objects.equals(this.peers, that.peers) && Objects.equals(this.relatives, that.relatives);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.parentType, this.parentId, this.friendlyName, this.peers, this.relatives);
    }

    public String toString() {
        return "ImmutableInventoryObject{type='" + this.type + '\'' + ", id='" + this.id + '\'' + ", parentType='" + this.parentType + '\'' + ", parentId='" + this.parentId + '\'' + ", subtype='" + this.subtype + '\'' + ", friendlyName='" + this.friendlyName + '\'' + ", isTopLevel=" + this.isTopLevel + ", peers=" + this.peers + ", relatives=" + this.relatives + ", weightToParent=" + this.weightToParent + '}';
    }

    public static final class Builder {
        private String type;
        private String id;
        private String parentType;
        private String parentId;
        private String subtype;
        private String friendlyName;
        private boolean isTopLevel;
        private List<InventoryObjectPeerRef> peers;
        private List<InventoryObjectRelativeRef> relatives;
        private long weightToParent;

        private Builder() {
            this.weightToParent = 100L;
        }

        private Builder(InventoryObject inventoryObject) {
            this.type = inventoryObject.getType();
            this.id = inventoryObject.getId();
            this.parentType = inventoryObject.getParentType();
            this.parentId = inventoryObject.getParentId();
            this.subtype = inventoryObject.getSubtype();
            this.friendlyName = inventoryObject.getFriendlyName();
            this.isTopLevel = inventoryObject.isTopLevel();
            this.peers = new ArrayList<InventoryObjectPeerRef>(inventoryObject.getPeers());
            this.relatives = new ArrayList<InventoryObjectRelativeRef>(inventoryObject.getRelatives());
            this.weightToParent = inventoryObject.getWeightToParent();
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setParentType(String parentType) {
            this.parentType = parentType;
            return this;
        }

        public Builder setParentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder setSubtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        public Builder setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        public Builder setTopLevel(boolean topLevel) {
            this.isTopLevel = topLevel;
            return this;
        }

        public Builder setPeers(List<InventoryObjectPeerRef> peers) {
            this.peers = peers;
            return this;
        }

        public Builder addPeer(InventoryObjectPeerRef peer) {
            if (this.peers == null) {
                this.peers = new ArrayList<InventoryObjectPeerRef>();
            }
            this.peers.add(peer);
            return this;
        }

        public Builder setRelatives(List<InventoryObjectRelativeRef> relatives) {
            this.relatives = relatives;
            return this;
        }

        public Builder addRelative(InventoryObjectRelativeRef relative) {
            if (this.relatives == null) {
                this.relatives = new ArrayList<InventoryObjectRelativeRef>();
            }
            this.relatives.add(relative);
            return this;
        }

        public Builder setWeightToParent(long weightToParent) {
            this.weightToParent = weightToParent;
            return this;
        }

        public ImmutableInventoryObject build() {
            Objects.requireNonNull(this.id, "Id cannot be null");
            Objects.requireNonNull(this.type, "Type cannot be null");
            if (this.parentType != null && this.parentId == null) {
                throw new IllegalArgumentException(String.format("Parent type was set to '%s', but the parent id is null. Id cannot be null.", this.parentType));
            }
            if (this.parentId != null && this.parentType == null) {
                throw new IllegalArgumentException(String.format("Parent id was set to '%s', but the parent type is null. Type cannot be null.", this.parentId));
            }
            return new ImmutableInventoryObject(this);
        }
    }
}

