/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.datasource.common;

import java.util.Objects;
import org.opennms.alec.datasource.api.InventoryObjectPeerEndpoint;
import org.opennms.alec.datasource.api.InventoryObjectPeerRef;

public final class ImmutableInventoryObjectPeerRef
implements InventoryObjectPeerRef {
    private final String type;
    private final String id;
    private final InventoryObjectPeerEndpoint endpoint;
    private final long weight;

    private ImmutableInventoryObjectPeerRef(Builder builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.endpoint = builder.endpoint;
        this.weight = builder.weight;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(InventoryObjectPeerRef inventoryObjectPeerRef) {
        return new Builder(inventoryObjectPeerRef);
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public InventoryObjectPeerEndpoint getEndpoint() {
        return this.endpoint;
    }

    public long getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableInventoryObjectPeerRef that = (ImmutableInventoryObjectPeerRef)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.id, that.id) && this.endpoint == that.endpoint;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.endpoint);
    }

    public String toString() {
        return "ImmutableInventoryObjectPeerRef{type='" + this.type + '\'' + ", id='" + this.id + '\'' + ", endpoint=" + this.endpoint + ", weight=" + this.weight + '}';
    }

    public static final class Builder {
        private String type;
        private String id;
        private InventoryObjectPeerEndpoint endpoint;
        private long weight;

        private Builder() {
            this.weight = 100L;
        }

        private Builder(InventoryObjectPeerRef inventoryObjectPeerRef) {
            this.type = inventoryObjectPeerRef.getType();
            this.id = inventoryObjectPeerRef.getId();
            this.endpoint = inventoryObjectPeerRef.getEndpoint();
            this.weight = inventoryObjectPeerRef.getWeight();
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setEndpoint(InventoryObjectPeerEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setWeight(long weight) {
            this.weight = weight;
            return this;
        }

        public ImmutableInventoryObjectPeerRef build() {
            Objects.requireNonNull(this.id, "Id cannot be null");
            Objects.requireNonNull(this.type, "Type cannot be null");
            return new ImmutableInventoryObjectPeerRef(this);
        }
    }
}

