/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.datasource.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.datasource.api.ResourceKey;
import org.opennms.alec.datasource.api.Severity;
import org.opennms.alec.datasource.api.Situation;
import org.opennms.alec.datasource.common.ImmutableAlarm;

public final class ImmutableSituation
implements Situation {
    private final String id;
    private final long creationTime;
    private final Severity severity;
    private final List<ResourceKey> resourceKeys;
    private final Map<String, Alarm> alarms;
    private final Set<Alarm> alarmsFromMap;
    private final String diagnosticText;

    private ImmutableSituation(Builder builder) {
        this.id = builder.id;
        this.creationTime = builder.creationTime;
        this.severity = builder.severity;
        this.resourceKeys = builder.resourceKeys == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ResourceKey>(builder.resourceKeys));
        this.alarms = builder.alarms == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.copyAlarms(builder.alarms));
        this.alarmsFromMap = Collections.unmodifiableSet(new HashSet<Alarm>(this.alarms.values()));
        this.diagnosticText = builder.diagnosticText;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderNow() {
        Builder builder = new Builder();
        builder.setCreationTime(System.currentTimeMillis());
        return builder;
    }

    public static Builder newBuilderFrom(Situation situation) {
        return new Builder(situation);
    }

    private Map<String, Alarm> copyAlarms(Map<String, Alarm> alarms) {
        return alarms.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Alarm alarm = (Alarm)entry.getValue();
            if (!(alarm instanceof ImmutableAlarm)) {
                return ImmutableAlarm.newBuilderFrom((Alarm)entry.getValue()).build();
            }
            return alarm;
        }, (oldAlarm, newAlarm) -> newAlarm, LinkedHashMap::new));
    }

    public String getId() {
        return this.id;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public List<ResourceKey> getResourceKeys() {
        return this.resourceKeys;
    }

    public Set<Alarm> getAlarms() {
        return this.alarmsFromMap;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getDiagnosticText() {
        return this.diagnosticText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSituation that = (ImmutableSituation)o;
        return this.creationTime == that.creationTime && this.severity == that.severity && Objects.equals(this.resourceKeys, that.resourceKeys) && Objects.equals(this.alarms, that.alarms) && Objects.equals(this.diagnosticText, that.diagnosticText);
    }

    public int hashCode() {
        return Objects.hash(this.creationTime, this.resourceKeys, this.alarms, this.severity, this.diagnosticText);
    }

    public String toString() {
        return "ImmutableSituation{id='" + this.id + "', creationTime=" + this.creationTime + ", severity=" + this.severity + ", resourceKeys=" + this.resourceKeys + ", alarms=" + this.alarms + ", diagnosticText='" + this.diagnosticText + "'}";
    }

    public static final class Builder {
        private String id;
        private Long creationTime;
        private Severity severity;
        private List<ResourceKey> resourceKeys;
        private Map<String, Alarm> alarms;
        private String diagnosticText;

        private Builder() {
        }

        private Builder(Situation situation) {
            this.id = situation.getId();
            this.creationTime = situation.getCreationTime();
            this.severity = situation.getSeverity();
            this.resourceKeys = new ArrayList<ResourceKey>(situation.getResourceKeys());
            this.alarms = situation.getAlarms().stream().collect(Collectors.toMap(Alarm::getId, alarm -> alarm, (oldAlarm, newAlarm) -> newAlarm, LinkedHashMap::new));
            this.diagnosticText = situation.getDiagnosticText();
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setCreationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder setSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder setResourceKeys(List<ResourceKey> resourceKeys) {
            this.resourceKeys = resourceKeys;
            return this;
        }

        public Builder addResourceKey(ResourceKey resourceKey) {
            if (this.resourceKeys == null) {
                this.resourceKeys = new ArrayList<ResourceKey>();
            }
            this.resourceKeys.add(resourceKey);
            return this;
        }

        public Builder setAlarms(Map<String, Alarm> alarms) {
            this.alarms = alarms;
            return this;
        }

        public Builder setAlarms(Set<Alarm> alarms) {
            this.alarms = alarms.stream().collect(Collectors.toMap(Alarm::getId, alarm -> alarm, (aOld, aNew) -> aNew, LinkedHashMap::new));
            return this;
        }

        public Builder addAlarm(Alarm alarm) {
            if (this.alarms == null) {
                this.alarms = new LinkedHashMap<String, Alarm>();
            }
            this.alarms.put(alarm.getId(), alarm);
            return this;
        }

        public Builder addAlarm(Alarm alarm, BiPredicate<String, String> predicate) {
            if (predicate.test(alarm.getId(), this.id)) {
                if (this.alarms == null) {
                    this.alarms = new LinkedHashMap<String, Alarm>();
                }
                this.alarms.put(alarm.getId(), alarm);
            }
            return this;
        }

        public Builder setDiagnosticText(String diagnosticText) {
            this.diagnosticText = diagnosticText;
            return this;
        }

        public ImmutableSituation build() {
            Objects.requireNonNull(this.id, "Id cannot be null");
            Objects.requireNonNull(this.creationTime, "creation time cannot be null");
            return new ImmutableSituation(this);
        }
    }
}

