/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.datasource.common;

import java.util.Objects;
import java.util.StringJoiner;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.datasource.api.Severity;

public final class ImmutableAlarm
implements Alarm {
    private final String id;
    private final long longId;
    private final long firstTime;
    private final long time;
    private final Severity severity;
    private final String inventoryObjectId;
    private final String inventoryObjectType;
    private final String summary;
    private final String description;
    private final Long nodeId;
    private final String nodeLocation;
    private final String nodeLabel;
    private final String reductionKey;

    private ImmutableAlarm(Builder builder) {
        this.id = builder.id;
        this.longId = builder.longId;
        this.firstTime = builder.firstTime;
        this.time = builder.time;
        this.severity = builder.severity;
        this.inventoryObjectId = builder.inventoryObjectId;
        this.inventoryObjectType = builder.inventoryObjectType;
        this.summary = builder.summary;
        this.description = builder.description;
        this.nodeId = builder.nodeId;
        this.nodeLabel = builder.nodeLabel;
        this.nodeLocation = builder.nodeLocation;
        this.reductionKey = builder.reductionKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(Alarm alarm) {
        return new Builder(alarm);
    }

    public String getId() {
        return this.id;
    }

    public long getLongId() {
        return this.longId;
    }

    public long getFirstTime() {
        return this.firstTime;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isClear() {
        return Severity.CLEARED == this.severity;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getInventoryObjectId() {
        return this.inventoryObjectId;
    }

    public String getInventoryObjectType() {
        return this.inventoryObjectType;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public String getNodeLocation() {
        return this.nodeLocation;
    }

    public String getReductionKey() {
        return this.reductionKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAlarm that = (ImmutableAlarm)o;
        return this.time == that.time && this.firstTime == that.firstTime && Objects.equals(this.id, that.id) && Objects.equals(this.longId, that.longId) && this.severity == that.severity && Objects.equals(this.inventoryObjectId, that.inventoryObjectId) && Objects.equals(this.inventoryObjectType, that.inventoryObjectType) && Objects.equals(this.summary, that.summary) && Objects.equals(this.description, that.description) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.nodeLabel, that.nodeLabel) && Objects.equals(this.nodeLocation, that.nodeLocation) && Objects.equals(this.reductionKey, that.reductionKey);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.longId, this.time, this.severity, this.inventoryObjectId, this.inventoryObjectType, this.summary, this.description, this.nodeId, this.nodeLabel, this.nodeLocation, this.reductionKey);
    }

    public String toString() {
        return new StringJoiner(", ", ImmutableAlarm.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("longId=" + this.longId).add("firstTime=" + this.firstTime).add("time=" + this.time).add("severity=" + this.severity).add("inventoryObjectId='" + this.inventoryObjectId + "'").add("inventoryObjectType='" + this.inventoryObjectType + "'").add("summary='" + this.summary + "'").add("description='" + this.description + "'").add("nodeId=" + this.nodeId).add("nodeLocation='" + this.nodeLocation + "'").add("nodeLabel='" + this.nodeLabel + "'").add("reductionKey='" + this.reductionKey + "'").toString();
    }

    public static final class Builder {
        private String id;
        private long longId;
        private long firstTime;
        private long time;
        private Severity severity;
        private String inventoryObjectId;
        private String inventoryObjectType;
        private String summary;
        private String description;
        private Long nodeId;
        private String nodeLabel;
        private String nodeLocation;
        private String reductionKey;

        private Builder() {
            this.firstTime = System.currentTimeMillis();
            this.time = System.currentTimeMillis();
        }

        private Builder(Alarm alarm) {
            this.id = alarm.getId();
            this.longId = alarm.getLongId();
            this.firstTime = alarm.getFirstTime();
            this.time = alarm.getTime();
            this.severity = alarm.getSeverity();
            this.inventoryObjectId = alarm.getInventoryObjectId();
            this.inventoryObjectType = alarm.getInventoryObjectType();
            this.summary = alarm.getSummary();
            this.description = alarm.getDescription();
            this.nodeId = alarm.getNodeId();
            this.nodeLabel = alarm.getNodeLabel();
            this.nodeLocation = alarm.getNodeLocation();
            this.reductionKey = alarm.getReductionKey();
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setLongId(long longId) {
            this.longId = longId;
            return this;
        }

        public Builder setFirstTime(long firstTime) {
            this.firstTime = firstTime;
            return this;
        }

        public Builder setTime(long time) {
            this.time = time;
            return this;
        }

        public Builder setSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder setInventoryObjectId(String inventoryObjectId) {
            this.inventoryObjectId = inventoryObjectId;
            return this;
        }

        public Builder setInventoryObjectType(String inventoryObjectType) {
            this.inventoryObjectType = inventoryObjectType;
            return this;
        }

        public Builder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setNodeId(Long nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setNodeLabel(String nodeLabel) {
            this.nodeLabel = nodeLabel;
            return this;
        }

        public Builder setNodeLocation(String nodeLocation) {
            this.nodeLocation = nodeLocation;
            return this;
        }

        public Builder setReductionKey(String reductionKey) {
            this.reductionKey = reductionKey;
            return this;
        }

        public ImmutableAlarm build() {
            Objects.requireNonNull(this.id, "Id cannot be null");
            return new ImmutableAlarm(this);
        }
    }
}

