/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.datasource.common;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerRegistry<T> {
    private static final Logger LOG = LoggerFactory.getLogger(HandlerRegistry.class);
    private final ReadWriteLock handlerLock = new ReentrantReadWriteLock();
    private final Set<T> handlers = new HashSet<T>();

    public void forEach(Consumer<T> consumer) {
        this.handlerLock.readLock().lock();
        try {
            this.handlers.forEach((? super T t) -> {
                try {
                    consumer.accept(t);
                }
                catch (Exception e) {
                    LOG.error("Error occurred on handler {}: {}", new Object[]{t, e.getMessage(), e});
                }
            });
        }
        finally {
            this.handlerLock.readLock().unlock();
        }
    }

    public void register(T handler, Consumer<Void> withLock) {
        this.handlerLock.writeLock().lock();
        try {
            this.handlers.add(handler);
            withLock.accept(null);
        }
        finally {
            this.handlerLock.writeLock().unlock();
        }
    }

    public void register(T handler) {
        this.handlerLock.writeLock().lock();
        try {
            this.handlers.add(handler);
        }
        finally {
            this.handlerLock.writeLock().unlock();
        }
    }

    public void unregister(T handler) {
        this.handlerLock.writeLock().lock();
        try {
            this.handlers.remove(handler);
        }
        finally {
            this.handlerLock.writeLock().unlock();
        }
    }
}

