/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.datasource.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.datasource.api.ResourceKey;
import org.opennms.alec.datasource.api.Severity;
import org.opennms.alec.datasource.api.Situation;
import org.opennms.alec.datasource.api.Status;
import org.opennms.alec.datasource.common.ImmutableAlarm;

public final class ImmutableSituation
implements Situation {
    private final String id;
    private final long longId;
    private final long creationTime;
    private final Severity severity;
    private final List<ResourceKey> resourceKeys;
    private final Map<String, Alarm> alarms;
    private final Set<Alarm> alarmsFromMap;
    private final String diagnosticText;
    private final Status status;
    private final String reductionKey;
    private final Long lastTime;
    private final String uei;
    private final String description;
    private final List<String> feedbacks;
    private final String engineParameter;

    private ImmutableSituation(Builder builder) {
        this.id = builder.id;
        this.longId = builder.longId;
        this.creationTime = builder.creationTime;
        this.severity = builder.severity;
        this.resourceKeys = builder.resourceKeys == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ResourceKey>(builder.resourceKeys));
        this.alarms = builder.alarms == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.copyAlarms(builder.alarms));
        this.alarmsFromMap = Collections.unmodifiableSet(new HashSet<Alarm>(this.alarms.values()));
        this.diagnosticText = builder.diagnosticText;
        this.status = builder.status;
        this.reductionKey = builder.reductionKey;
        this.lastTime = builder.lastTime;
        this.uei = builder.uei;
        this.description = builder.description;
        this.feedbacks = builder.feedbacks == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(builder.feedbacks));
        this.engineParameter = builder.engineParameter;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderNow() {
        Builder builder = new Builder();
        builder.setCreationTime(System.currentTimeMillis());
        return builder;
    }

    public static Builder newBuilderFrom(Situation situation) {
        return new Builder(situation);
    }

    private Map<String, Alarm> copyAlarms(Map<String, Alarm> alarms) {
        return alarms.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Alarm alarm = (Alarm)entry.getValue();
            if (!(alarm instanceof ImmutableAlarm)) {
                return ImmutableAlarm.newBuilderFrom((Alarm)entry.getValue()).build();
            }
            return alarm;
        }, (oldAlarm, newAlarm) -> newAlarm, LinkedHashMap::new));
    }

    public String getId() {
        return this.id;
    }

    public long getLongId() {
        return this.longId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public List<ResourceKey> getResourceKeys() {
        return this.resourceKeys;
    }

    public Set<Alarm> getAlarms() {
        return this.alarmsFromMap;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getDiagnosticText() {
        return this.diagnosticText;
    }

    public Status getStatus() {
        return Optional.ofNullable(this.status).orElse(Status.CREATED);
    }

    public String getReductionKey() {
        return this.reductionKey;
    }

    public Long getLastTime() {
        return this.lastTime;
    }

    public String getUei() {
        return this.uei;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getFeedback() {
        return this.feedbacks;
    }

    public String getEngineParameter() {
        return this.engineParameter;
    }

    public String toString() {
        return new StringJoiner(", ", ImmutableSituation.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("longId=" + this.longId).add("creationTime=" + this.creationTime).add("severity=" + this.severity).add("resourceKeys=" + this.resourceKeys).add("alarms=" + this.alarms).add("alarmsFromMap=" + this.alarmsFromMap).add("diagnosticText='" + this.diagnosticText + "'").add("status=" + this.status).add("reductionKey='" + this.reductionKey + "'").add("lastTime=" + this.lastTime).add("uei='" + this.uei + "'").add("description='" + this.description + "'").add("feedbacks=" + this.feedbacks).add("engineParameter='" + this.engineParameter + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSituation that = (ImmutableSituation)o;
        return this.longId == that.longId && this.creationTime == that.creationTime && Objects.equals(this.id, that.id) && this.severity == that.severity && Objects.equals(this.resourceKeys, that.resourceKeys) && Objects.equals(this.alarms, that.alarms) && Objects.equals(this.alarmsFromMap, that.alarmsFromMap) && Objects.equals(this.diagnosticText, that.diagnosticText) && this.status == that.status && Objects.equals(this.reductionKey, that.reductionKey) && Objects.equals(this.lastTime, that.lastTime) && Objects.equals(this.uei, that.uei) && Objects.equals(this.description, that.description) && Objects.equals(this.feedbacks, that.feedbacks) && Objects.equals(this.engineParameter, that.engineParameter);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.longId, this.creationTime, this.severity, this.resourceKeys, this.alarms, this.alarmsFromMap, this.diagnosticText, this.status, this.reductionKey, this.lastTime, this.uei, this.description, this.feedbacks, this.engineParameter);
    }

    public static final class Builder {
        private String id;
        private long longId;
        private Long creationTime;
        private Severity severity;
        private List<ResourceKey> resourceKeys;
        private Map<String, Alarm> alarms;
        private String diagnosticText;
        private Status status;
        private String reductionKey;
        private Long lastTime;
        private String uei;
        private String description;
        private List<String> feedbacks;
        private String engineParameter;

        private Builder() {
        }

        private Builder(Situation situation) {
            this.id = situation.getId();
            this.longId = situation.getLongId();
            this.creationTime = situation.getCreationTime();
            this.severity = situation.getSeverity();
            this.resourceKeys = new ArrayList<ResourceKey>(situation.getResourceKeys());
            this.alarms = situation.getAlarms().stream().collect(Collectors.toMap(Alarm::getId, alarm -> alarm, (oldAlarm, newAlarm) -> newAlarm, LinkedHashMap::new));
            this.diagnosticText = situation.getDiagnosticText();
            this.status = situation.getStatus();
            this.reductionKey = situation.getReductionKey();
            this.lastTime = situation.getLastTime();
            this.uei = situation.getUei();
            this.description = situation.getDescription();
            this.feedbacks = new ArrayList<String>(situation.getFeedback());
            this.engineParameter = situation.getEngineParameter();
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setLongId(long longId) {
            this.longId = longId;
            return this;
        }

        public Builder setCreationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder setSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder setResourceKeys(List<ResourceKey> resourceKeys) {
            this.resourceKeys = resourceKeys;
            return this;
        }

        public Builder addResourceKey(ResourceKey resourceKey) {
            if (this.resourceKeys == null) {
                this.resourceKeys = new ArrayList<ResourceKey>();
            }
            this.resourceKeys.add(resourceKey);
            return this;
        }

        public Builder setAlarms(Map<String, Alarm> alarms) {
            this.alarms = alarms;
            return this;
        }

        public Builder setAlarms(Set<Alarm> alarms) {
            this.alarms = alarms.stream().collect(Collectors.toMap(Alarm::getId, alarm -> alarm, (aOld, aNew) -> aNew, LinkedHashMap::new));
            return this;
        }

        public Builder addAlarm(Alarm alarm) {
            if (this.alarms == null) {
                this.alarms = new LinkedHashMap<String, Alarm>();
            }
            this.alarms.put(alarm.getId(), alarm);
            return this;
        }

        public Builder addAlarm(Alarm alarm, BiPredicate<String, String> predicate) {
            if (predicate.test(alarm.getId(), this.id)) {
                if (this.alarms == null) {
                    this.alarms = new LinkedHashMap<String, Alarm>();
                }
                this.alarms.put(alarm.getId(), alarm);
            }
            return this;
        }

        public Builder setDiagnosticText(String diagnosticText) {
            this.diagnosticText = diagnosticText;
            return this;
        }

        public Builder setStatus(Status status) {
            this.status = status;
            return this;
        }

        public Builder setReductionKey(String reductionKey) {
            this.reductionKey = reductionKey;
            return this;
        }

        public Builder setLastTime(Long lastTime) {
            this.lastTime = lastTime;
            return this;
        }

        public Builder setUei(String uei) {
            this.uei = uei;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setFeedbacks(List<String> feedbacks) {
            this.feedbacks = feedbacks;
            return this;
        }

        public Builder addFeedback(String feedback) {
            if (this.feedbacks == null) {
                this.feedbacks = new ArrayList<String>();
            }
            this.feedbacks.add(feedback);
            return this;
        }

        public Builder setEngineParameter(String engineParameter) {
            this.engineParameter = engineParameter;
            return this;
        }

        public ImmutableSituation build() {
            Objects.requireNonNull(this.id, "Id cannot be null");
            Objects.requireNonNull(this.creationTime, "creation time cannot be null");
            return new ImmutableSituation(this);
        }
    }
}

