/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.datasource.jaxb;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.datasource.api.Situation;
import org.opennms.alec.datasource.v1.schema.Inventory;
import org.opennms.alec.datasource.v1.schema.MetaModel;
import org.osgi.framework.BundleContext;
import org.xml.sax.SAXException;

public class ResourceLoader {
    private static final String SCHEMA_RESOURCE = "/model.v1.xsd";
    private static final String METAMODEL_RESOURCE = "/metamodel.xml";
    private static final String INVENTORY_RESOURCE = "/inventory.xml";
    private final BundleContext bundleContext;
    private final Schema modelSchema;
    private final JAXBContext jaxbContext;
    private String metamodelPath = "/metamodel.xml";
    private String inventoryPath = "/inventory.xml";

    public ResourceLoader() {
        this(null);
    }

    public ResourceLoader(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            this.modelSchema = sf.newSchema(this.getResource(SCHEMA_RESOURCE));
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MetaModel.class, Inventory.class});
        }
        catch (JAXBException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Alarm> getAlarms() {
        return Collections.emptyList();
    }

    public List<Situation> getSituations() {
        return Collections.emptyList();
    }

    private URL getResource(String resource) {
        URL bundleResourceUrl;
        File file = new File(resource);
        if (file.canRead()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        URL classpathResourceUrl = MetaModel.class.getResource(resource);
        if (classpathResourceUrl != null) {
            return classpathResourceUrl;
        }
        if (this.bundleContext != null && (bundleResourceUrl = this.bundleContext.getBundle().getResource(resource)) != null) {
            return bundleResourceUrl;
        }
        throw new IllegalArgumentException("Failed to locate resource on the filesystem and in the classpath: " + resource);
    }
}

