/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.datasource.jaxb;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.datasource.api.InventoryObject;
import org.opennms.alec.datasource.api.InventoryObjectPeerEndpoint;
import org.opennms.alec.datasource.api.InventoryObjectPeerRef;
import org.opennms.alec.datasource.api.InventoryObjectRelativeRef;
import org.opennms.alec.datasource.api.Severity;
import org.opennms.alec.datasource.common.ImmutableAlarm;
import org.opennms.alec.datasource.common.ImmutableInventoryObject;
import org.opennms.alec.datasource.common.ImmutableInventoryObjectPeerRef;
import org.opennms.alec.datasource.common.ImmutableInventoryObjectRelativeRef;
import org.opennms.alec.datasource.common.ImmutableSituation;
import org.opennms.alec.datasource.v1.schema.AlarmRef;
import org.opennms.alec.datasource.v1.schema.Alarms;
import org.opennms.alec.datasource.v1.schema.Event;
import org.opennms.alec.datasource.v1.schema.Inventory;
import org.opennms.alec.datasource.v1.schema.ModelObjectEntry;
import org.opennms.alec.datasource.v1.schema.PeerRef;
import org.opennms.alec.datasource.v1.schema.RelativeRef;
import org.opennms.alec.datasource.v1.schema.Situation;
import org.opennms.alec.datasource.v1.schema.Situations;

public class JaxbUtils {
    private static final String SCHEMA_RESOURCE = "/model.v1.xsd";
    private static final Gson gson = new Gson();

    public static Alarm toAlarm(org.opennms.alec.datasource.v1.schema.Alarm alarm, Event event) {
        return ImmutableAlarm.newBuilder().setId(alarm.getId()).setFirstTime(alarm.getFirstEventTime()).setTime(event.getTime()).setInventoryObjectType(alarm.getInventoryObjectType()).setInventoryObjectId(alarm.getInventoryObjectId()).setSeverity(JaxbUtils.toSeverity(event.getSeverity())).setSummary(event.getSummary()).setDescription(event.getDescription()).build();
    }

    public static Severity toSeverity(org.opennms.alec.datasource.v1.schema.Severity severity) {
        if (severity == null) {
            return null;
        }
        switch (severity) {
            case CRITICAL: {
                return Severity.CRITICAL;
            }
            case MAJOR: {
                return Severity.MAJOR;
            }
            case MINOR: {
                return Severity.MINOR;
            }
            case WARNING: {
                return Severity.WARNING;
            }
            case NORMAL: {
                return Severity.NORMAL;
            }
            case CLEARED: {
                return Severity.CLEARED;
            }
        }
        return Severity.INDETERMINATE;
    }

    private static org.opennms.alec.datasource.v1.schema.Severity toSeverity(Severity severity) {
        if (severity == null) {
            return null;
        }
        switch (severity) {
            case CRITICAL: {
                return org.opennms.alec.datasource.v1.schema.Severity.CRITICAL;
            }
            case MAJOR: {
                return org.opennms.alec.datasource.v1.schema.Severity.MAJOR;
            }
            case MINOR: {
                return org.opennms.alec.datasource.v1.schema.Severity.MINOR;
            }
            case WARNING: {
                return org.opennms.alec.datasource.v1.schema.Severity.WARNING;
            }
            case NORMAL: {
                return org.opennms.alec.datasource.v1.schema.Severity.NORMAL;
            }
            case CLEARED: {
                return org.opennms.alec.datasource.v1.schema.Severity.CLEARED;
            }
        }
        return org.opennms.alec.datasource.v1.schema.Severity.INDETERMINATE;
    }

    public static Situation toModelSituation(org.opennms.alec.datasource.api.Situation situation) {
        Situation modelSituation = new Situation();
        modelSituation.setId(situation.getId());
        modelSituation.setSeverity(JaxbUtils.toSeverity(situation.getSeverity()));
        modelSituation.setCreationTime(situation.getCreationTime());
        for (Alarm a : situation.getAlarms()) {
            AlarmRef alarmRef = new AlarmRef();
            alarmRef.setId(a.getId());
            modelSituation.getAlarmRef().add(alarmRef);
        }
        return modelSituation;
    }

    public static org.opennms.alec.datasource.api.Situation toEngineSituation(Situation situation) {
        return ImmutableSituation.newBuilder().setId(situation.getId()).setCreationTime(situation.getCreationTime()).setSeverity(JaxbUtils.toSeverity(situation.getSeverity())).setAlarms(situation.getAlarmRef().stream().map(alarmRef -> ImmutableAlarm.newBuilder().setId(alarmRef.getId()).build()).collect(Collectors.toSet())).build();
    }

    public static Set<org.opennms.alec.datasource.api.Situation> getSituations(Path path) throws JAXBException, IOException {
        Set<org.opennms.alec.datasource.api.Situation> set;
        block8: {
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            try {
                set = JaxbUtils.getSituations(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return set;
    }

    public static Set<org.opennms.alec.datasource.api.Situation> getSituations(InputStream is) throws JAXBException, IOException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Situations.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        List<Situation> xmlSituations = ((Situations)unmarshaller.unmarshal(is)).getSituation();
        return xmlSituations.stream().map(JaxbUtils::toEngineSituation).collect(Collectors.toSet());
    }

    public static void writeSituations(Map<String, org.opennms.alec.datasource.api.Situation> situations, String outFile) throws JAXBException, IOException {
        String filepath = outFile == null || outFile.isEmpty() ? "situations.xml" : outFile;
        try (OutputStream os = Files.newOutputStream(Paths.get(filepath, new String[0]), new OpenOption[0]);){
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Situations.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            Situations list = new Situations();
            list.getSituation().addAll(situations.values().stream().map(JaxbUtils::toModelSituation).collect(Collectors.toList()));
            marshaller.marshal((Object)list, os);
        }
    }

    public static List<Alarm> getAlarms(Path path) throws JAXBException, IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            List<Alarm> list = JaxbUtils.getAlarms(is);
            return list;
        }
    }

    public static List<Alarm> getAlarms(InputStream is) throws JAXBException, IOException {
        JAXBContext jaxbContext;
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Alarms.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        Alarms alarms = (Alarms)unmarshaller.unmarshal(is);
        ArrayList<Alarm> engineAlarms = new ArrayList<Alarm>();
        for (org.opennms.alec.datasource.v1.schema.Alarm alarm : alarms.getAlarm()) {
            for (Event event : alarm.getEvent()) {
                engineAlarms.add(JaxbUtils.toAlarm(alarm, event));
            }
        }
        return engineAlarms;
    }

    public static List<InventoryObject> getInventory(Path path) throws IOException, JAXBException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            List<InventoryObject> list = JaxbUtils.getInventory(is);
            return list;
        }
    }

    public static List<InventoryObject> getInventory(InputStream is) throws IOException, JAXBException {
        JAXBContext jaxbContext;
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Inventory.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        Inventory inventory = (Inventory)unmarshaller.unmarshal(is);
        return JaxbUtils.toInventoryObjects(inventory);
    }

    public static List<InventoryObject> toInventoryObjects(Inventory inventory) {
        ArrayList<InventoryObject> ios = new ArrayList<InventoryObject>();
        for (ModelObjectEntry modelObjectEntry : inventory.getModelObjectEntry()) {
            InventoryObject io = JaxbUtils.toInventoryObject(modelObjectEntry);
            if (io == null) continue;
            ios.add(io);
        }
        return ios;
    }

    private static InventoryObject toInventoryObject(ModelObjectEntry moe) {
        if ("model".equals(moe.getId()) && "Model".equals(moe.getType())) {
            return null;
        }
        ImmutableInventoryObject.Builder ioBuilder = ImmutableInventoryObject.newBuilder().setId(moe.getId()).setType(moe.getType());
        if (!"model".equals(moe.getParentId()) || !"Model".equals(moe.getParentType())) {
            ioBuilder.setParentId(moe.getParentId()).setParentType(moe.getParentType());
        }
        ioBuilder.setFriendlyName(moe.getFriendlyName());
        if (moe.getPeerRef() != null) {
            for (PeerRef peerRef : moe.getPeerRef()) {
                ImmutableInventoryObjectPeerRef.Builder peerRefBuilder = ImmutableInventoryObjectPeerRef.newBuilder().setId(peerRef.getId()).setType(peerRef.getType());
                if ("A".equalsIgnoreCase(peerRef.getEndpoint())) {
                    peerRefBuilder.setEndpoint(InventoryObjectPeerEndpoint.A);
                } else {
                    peerRefBuilder.setEndpoint(InventoryObjectPeerEndpoint.Z);
                }
                if (peerRef.getWeight() != null) {
                    peerRefBuilder.setWeight(peerRef.getWeight().longValue());
                }
                ioBuilder.addPeer((InventoryObjectPeerRef)peerRefBuilder.build());
            }
        }
        if (moe.getRelativeRef() != null) {
            for (RelativeRef relativeRef : moe.getRelativeRef()) {
                ImmutableInventoryObjectRelativeRef.Builder relativeRefBuilder = ImmutableInventoryObjectRelativeRef.newBuilder().setId(relativeRef.getId()).setType(relativeRef.getType());
                if (relativeRef.getWeight() != null) {
                    relativeRefBuilder.setWeight(relativeRef.getWeight().longValue());
                }
                ioBuilder.addRelative((InventoryObjectRelativeRef)relativeRefBuilder.build());
            }
        }
        if (moe.getWeightToParent() != null) {
            ioBuilder.setWeightToParent(moe.getWeightToParent().longValue());
        }
        return ioBuilder.build();
    }

    public static Inventory toInventory(List<InventoryObject> ios) {
        Inventory inventory = new Inventory();
        for (InventoryObject io : ios) {
            ModelObjectEntry moe = new ModelObjectEntry();
            moe.setId(io.getId());
            moe.setType(io.getType());
            moe.setParentId(io.getParentId());
            moe.setParentType(io.getParentType());
            moe.setFriendlyName(io.getFriendlyName());
            moe.setWeightToParent(io.getWeightToParent());
            for (InventoryObjectPeerRef peerRef : io.getPeers()) {
                moe.getPeerRef().add(JaxbUtils.toPeerRef(peerRef));
            }
            for (InventoryObjectRelativeRef relativeRef : io.getRelatives()) {
                moe.getRelativeRef().add(JaxbUtils.toRelativeRef(relativeRef));
            }
            inventory.getModelObjectEntry().add(moe);
        }
        return inventory;
    }

    private static PeerRef toPeerRef(InventoryObjectPeerRef ioPeerRef) {
        PeerRef peerRef = new PeerRef();
        peerRef.setId(ioPeerRef.getId());
        peerRef.setType(ioPeerRef.getType());
        peerRef.setWeight(ioPeerRef.getWeight());
        peerRef.setEndpoint(ioPeerRef.getEndpoint().name());
        return peerRef;
    }

    private static RelativeRef toRelativeRef(InventoryObjectRelativeRef ioRelativeRef) {
        RelativeRef relativeRef = new RelativeRef();
        relativeRef.setId(ioRelativeRef.getId());
        relativeRef.setType(ioRelativeRef.getType());
        relativeRef.setWeight(ioRelativeRef.getWeight());
        return relativeRef;
    }

    public static List<org.opennms.alec.datasource.v1.schema.Alarm> getRawAlarms(Path path) throws JAXBException, IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            JAXBContext jaxbContext;
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Alarms.class});
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Alarms alarms = (Alarms)unmarshaller.unmarshal(is);
            List<org.opennms.alec.datasource.v1.schema.Alarm> list = alarms.getAlarm();
            return list;
        }
    }

    public static void writeSituations(List<org.opennms.alec.datasource.api.Situation> situations, Path path) throws IOException, JAXBException {
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Situations.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            Situations list = new Situations();
            list.getSituation().addAll(situations.stream().map(JaxbUtils::toModelSituation).collect(Collectors.toList()));
            marshaller.marshal((Object)list, os);
        }
    }

    public static Alarms toAlarms(List<Alarm> apiAlarms) {
        Alarms alarms = new Alarms();
        for (Alarm apiAlarm : apiAlarms) {
            org.opennms.alec.datasource.v1.schema.Alarm alarm = new org.opennms.alec.datasource.v1.schema.Alarm();
            alarm.setId(apiAlarm.getId());
            alarm.setSummary(apiAlarm.getSummary());
            alarm.setDescription(apiAlarm.getDescription());
            alarm.setInventoryObjectId(apiAlarm.getInventoryObjectId());
            alarm.setInventoryObjectType(apiAlarm.getInventoryObjectType());
            alarm.setLastSeverity(JaxbUtils.toSeverity(apiAlarm.getSeverity()));
            alarm.setFirstEventTime(apiAlarm.getFirstTime());
            alarm.setLastEventTime(apiAlarm.getTime());
            Event event = new Event();
            event.setId(apiAlarm.getId());
            event.setSummary(apiAlarm.getSummary());
            event.setDescription(apiAlarm.getDescription());
            event.setSeverity(JaxbUtils.toSeverity(apiAlarm.getSeverity()));
            event.setTime(apiAlarm.getTime());
            alarm.getEvent().add(event);
            alarms.getAlarm().add(alarm);
        }
        return alarms;
    }

    public static Situations toSituations(List<org.opennms.alec.datasource.api.Situation> apiSituations) {
        Situations situations = new Situations();
        for (org.opennms.alec.datasource.api.Situation apiSituation : apiSituations) {
            situations.getSituation().add(JaxbUtils.toModelSituation(apiSituation));
        }
        return situations;
    }

    public static void write(Object o, Path targetFile) throws IOException, JAXBException {
        try (OutputStream os = Files.newOutputStream(targetFile, new OpenOption[0]);){
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{o.getClass()});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(o, os);
        }
    }
}

