/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.datasource.shell;

import de.vandermeer.asciitable.AT_ColumnWidthCalculator;
import de.vandermeer.asciitable.AsciiTable;
import de.vandermeer.asciitable.CWC_LongestLine;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.datasource.api.AlarmDatasource;

@Command(scope="opennms-alec", name="alarms", description="List the alarms known by the datasource.")
@Service
public class AlarmList
implements Action {
    @Reference
    private AlarmDatasource alarmDatasource;

    public Object execute() {
        AlarmList.printAlarms(this.alarmDatasource.getAlarms());
        return null;
    }

    private static void printAlarms(List<? extends Alarm> alarms) {
        AsciiTable at = new AsciiTable();
        at.addRule();
        at.addRow(new Object[]{"ID", "Time", "Severity", "Node ID", "IO Type", "IO ID"});
        at.addRule();
        alarms.stream().sorted(Comparator.comparing(Alarm::getTime).reversed().thenComparing(Alarm::getId)).forEach(a -> {
            at.addRow(new Object[]{a.getId(), new Date(a.getTime()), a.getSeverity(), a.getNodeId(), a.getInventoryObjectType(), a.getInventoryObjectId()});
            at.addRule();
        });
        CWC_LongestLine cwc = new CWC_LongestLine();
        at.getRenderer().setCWC((AT_ColumnWidthCalculator)cwc);
        System.out.println(at.render());
    }
}

