/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.datasource.shell;

import de.vandermeer.asciitable.AT_ColumnWidthCalculator;
import de.vandermeer.asciitable.AsciiTable;
import de.vandermeer.asciitable.CWC_LongestLine;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.datasource.api.ResourceKey;
import org.opennms.alec.datasource.api.Situation;
import org.opennms.alec.datasource.api.SituationDatasource;

@Command(scope="opennms-alec", name="situations", description="List the situations known by the datasource")
@Service
public class SituationList
implements Action {
    @Reference
    private SituationDatasource situationDatasource;

    public Object execute() throws InterruptedException {
        SituationList.printSituations(this.situationDatasource.getSituations());
        return null;
    }

    private static void printSituations(List<Situation> situations) {
        AsciiTable at = new AsciiTable();
        at.addRule();
        at.addRow(new Object[]{"ID", "Creation Time", "Severity", "# Alarms", "Alarm IDs", "Resource Keys"});
        at.addRule();
        situations.stream().sorted(Comparator.comparing(Situation::getCreationTime).reversed().thenComparing(Situation::getId)).forEach(s -> {
            at.addRow(new Object[]{s.getId(), new Date(s.getCreationTime()), s.getSeverity(), s.getAlarms().size(), s.getAlarms().stream().map(Alarm::getId).collect(Collectors.joining(",")), s.getResourceKeys().stream().map(ResourceKey::toString).collect(Collectors.joining(","))});
            at.addRule();
        });
        CWC_LongestLine cwc = new CWC_LongestLine();
        at.getRenderer().setCWC((AT_ColumnWidthCalculator)cwc);
        System.out.println(at.render());
    }
}

