/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.driver.main;

import java.util.Objects;
import org.opennms.alec.datasource.api.SituationHandler;
import org.opennms.alec.engine.api.Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletingSituationHandler
implements SituationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DeletingSituationHandler.class);
    private final Engine engine;

    private DeletingSituationHandler(Engine engine) {
        this.engine = Objects.requireNonNull(engine);
    }

    public static DeletingSituationHandler newInstance(Engine engine) {
        return new DeletingSituationHandler(engine);
    }

    public void onSituationDeleted(String situationId) {
        try {
            this.engine.deleteSituation(situationId);
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted while trying to delete situation with Id {}", (Object)situationId);
            Thread.currentThread().interrupt();
        }
    }
}

