/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.driver.main;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.jmx.JmxReporter;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.opennms.alec.datasource.api.AlarmDatasource;
import org.opennms.alec.datasource.api.AlarmFeedbackDatasource;
import org.opennms.alec.datasource.api.AlarmFeedbackHandler;
import org.opennms.alec.datasource.api.AlarmHandler;
import org.opennms.alec.datasource.api.InventoryDatasource;
import org.opennms.alec.datasource.api.InventoryHandler;
import org.opennms.alec.datasource.api.Situation;
import org.opennms.alec.datasource.api.SituationDatasource;
import org.opennms.alec.datasource.api.SituationHandler;
import org.opennms.alec.driver.main.DeletingSituationHandler;
import org.opennms.alec.driver.main.DriverState;
import org.opennms.alec.engine.api.Engine;
import org.opennms.alec.engine.api.EngineFactory;
import org.opennms.alec.engine.api.EngineRegistry;
import org.opennms.alec.features.graph.api.GraphProvider;
import org.opennms.alec.processor.api.SituationConfirmer;
import org.opennms.alec.processor.api.SituationProcessor;
import org.opennms.alec.processor.api.SituationProcessorFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
implements EngineRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(Driver.class);
    private final AlarmDatasource alarmDatasource;
    private final AlarmFeedbackDatasource alarmFeedbackDatasource;
    private final InventoryDatasource inventoryDatasource;
    private final SituationDatasource situationDatasource;
    private final BundleContext bundleContext;
    private final AtomicReference<ServiceRegistration<?>> graphProviderServiceRegistrationRef = new AtomicReference();
    private final SituationProcessor situationProcessor;
    private final SituationHandler confirmingSituationHandler;
    private SituationHandler deletingSituationHandler;
    private Thread initThread;
    private Engine engine;
    private java.util.Timer timer;
    private EngineFactory engineFactory;
    private final MetricRegistry metrics;
    private final JmxReporter jmxReporter;
    private final Timer ticks;
    private long tickResolutionMs = 0L;
    private DriverState state = DriverState.CREATED;

    public Driver(BundleContext bundleContext, AlarmDatasource alarmDatasource, AlarmFeedbackDatasource alarmFeedbackDatasource, InventoryDatasource inventoryDatasource, SituationDatasource situationDatasource, EngineFactory engineFactory, SituationProcessorFactory situationProcessorFactory) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
        this.alarmDatasource = Objects.requireNonNull(alarmDatasource);
        this.alarmFeedbackDatasource = Objects.requireNonNull(alarmFeedbackDatasource);
        this.inventoryDatasource = Objects.requireNonNull(inventoryDatasource);
        this.situationDatasource = Objects.requireNonNull(situationDatasource);
        this.engineFactory = Objects.requireNonNull(engineFactory);
        this.situationProcessor = Objects.requireNonNull(situationProcessorFactory).getInstance();
        this.confirmingSituationHandler = SituationConfirmer.newInstance((SituationProcessor)this.situationProcessor);
        this.metrics = new MetricRegistry();
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metrics).inDomain(MetricRegistry.name(Driver.class, (String[])new String[]{engineFactory.getName()})).build();
        this.ticks = this.metrics.timer(MetricRegistry.name((String)"ticks", (String[])new String[0]));
    }

    public void init() {
        this.initAsync();
    }

    public CompletableFuture<Void> initAsync() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        LOG.info("Creating engine: {}", (Object)this.engineFactory.getNameConf());
        try {
            this.engine = this.engineFactory.createEngine(this.metrics);
        }
        catch (IllegalArgumentException e) {
            future.completeExceptionally(e);
            return future;
        }
        this.situationDatasource.registerHandler(this.confirmingSituationHandler);
        this.engine.registerSituationHandler(new SituationHandler(){

            public void onSituation(Situation situation) {
                Driver.this.situationProcessor.accept(situation);
            }
        });
        this.timer = new java.util.Timer();
        this.initThread = new Thread(() -> {
            try {
                this.state = DriverState.WAITING_FOR_DATASOURCES;
                LOG.info("Waiting for inventory datasource...");
                this.inventoryDatasource.waitUntilReady();
                LOG.info("Waiting for alarm datasource...");
                this.alarmDatasource.waitUntilReady();
                LOG.info("Waiting for alarm feedback datasource...");
                this.alarmFeedbackDatasource.waitUntilReady();
                LOG.info("Waiting for situation datasource...");
                this.situationDatasource.waitUntilReady();
                LOG.info("All datasources are now available");
                this.deletingSituationHandler = DeletingSituationHandler.newInstance(this.engine);
                this.situationDatasource.registerHandler(this.deletingSituationHandler);
                this.state = DriverState.INITIALIZING_ENGINE;
                LOG.info("Retrieving inventory...");
                List inventory = this.inventoryDatasource.getInventoryAndRegisterHandler((InventoryHandler)this.engine);
                LOG.info("Retrieving alarms...");
                List alarms = this.alarmDatasource.getAlarmsAndRegisterHandler((AlarmHandler)this.engine);
                LOG.info("Retrieving alarm feedback...");
                List alarmFeedback = this.alarmFeedbackDatasource.getAlarmFeedbackAndRegisterHandler((AlarmFeedbackHandler)this.engine);
                LOG.info("Retrieving situations...");
                List situations = this.situationDatasource.getSituations();
                LOG.info("Initializing engine...");
                this.engine.init(alarms, alarmFeedback, situations, inventory);
                if (this.engine instanceof GraphProvider) {
                    LOG.info("Registering graph provider...");
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    props.put("name", this.engineFactory.getName());
                    this.graphProviderServiceRegistrationRef.set(this.bundleContext.registerService(GraphProvider.class.getCanonicalName(), (Object)this.engine, props));
                }
                this.jmxReporter.start();
            }
            catch (Exception e) {
                if (e.getCause() instanceof InterruptedException) {
                    LOG.warn("Initialization was interrupted.");
                    Thread.currentThread().interrupt();
                } else {
                    LOG.error("Initialization failed with exception.", (Throwable)e);
                }
                future.completeExceptionally(e);
                return;
            }
            LOG.info("Initialization successful. Scheduling ticks every {}ms", (Object)this.engine.getTickResolutionMs());
            this.tickResolutionMs = this.engine.getTickResolutionMs();
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    Thread.currentThread().setName("ALEC Driver Tick -- " + Driver.this.engineFactory.getParameters());
                    try (Timer.Context context = Driver.this.ticks.time();){
                        Driver.this.engine.tick(System.currentTimeMillis());
                    }
                    catch (Exception e) {
                        LOG.error("Tick failed with exception.", (Throwable)e);
                    }
                }
            }, 0L, this.tickResolutionMs);
            this.state = DriverState.RUNNING;
            future.complete(null);
        });
        this.initThread.setName(String.format("ALEC Driver Startup [%s]", this.engineFactory.getNameConf()));
        this.initThread.setUncaughtExceptionHandler((th, ex) -> {
            LOG.error("Initialization failed with uncaught exception.", ex);
            future.completeExceptionally(ex);
        });
        this.initThread.start();
        return future;
    }

    public void destroy() {
        ServiceRegistration serviceRegistration;
        this.state = DriverState.DESTROYING;
        this.situationDatasource.unregisterHandler(this.deletingSituationHandler);
        this.situationDatasource.unregisterHandler(this.confirmingSituationHandler);
        if (this.initThread != null && this.initThread.isAlive()) {
            this.initThread.interrupt();
            try {
                this.initThread.join(TimeUnit.MINUTES.toMillis(1L));
                if (this.initThread.isAlive()) {
                    LOG.warn("Initializing thread is still running.");
                }
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting for initialization thread to stop.");
                Thread.currentThread().interrupt();
            }
        }
        if ((serviceRegistration = (ServiceRegistration)this.graphProviderServiceRegistrationRef.getAndSet(null)) != null) {
            serviceRegistration.unregister();
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.engine != null) {
            this.engine.destroy();
            this.engine = null;
        }
        this.jmxReporter.stop();
        this.state = DriverState.DESTROYED;
    }

    DriverState getState() {
        return this.state;
    }

    long getTickResolutionMs() {
        return this.tickResolutionMs;
    }

    Timer getTickTimer() {
        return this.ticks;
    }

    public Collection<Engine> getEngines() {
        if (DriverState.RUNNING.equals((Object)this.state)) {
            return Collections.singleton(this.engine);
        }
        return Collections.emptyList();
    }

    public EngineRegistry getEngineRegistry() {
        return this;
    }

    public EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    public void setEngineFactory(EngineFactory engineFactory) {
        this.engineFactory = engineFactory;
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }
}

