/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.driver.main;

import com.codahale.metrics.Timer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opennms.alec.driver.main.Driver;
import org.opennms.alec.driver.main.DriverState;
import org.opennms.integration.api.v1.health.Context;
import org.opennms.integration.api.v1.health.HealthCheck;
import org.opennms.integration.api.v1.health.Response;
import org.opennms.integration.api.v1.health.Status;
import org.opennms.integration.api.v1.health.immutables.ImmutableResponse;

public class DriverHealthCheck
implements HealthCheck {
    private final Driver driver;

    public DriverHealthCheck(Driver driver) {
        this.driver = Objects.requireNonNull(driver);
    }

    public String getDescription() {
        return "ALEC :: Driver";
    }

    public Response perform(Context context) {
        DriverState state = this.driver.getState();
        if (!Objects.equals((Object)DriverState.RUNNING, (Object)state)) {
            return ImmutableResponse.newInstance((Status)Status.Failure, (String)("Driver is " + state));
        }
        Timer ticks = this.driver.getTickTimer();
        long tickResolutionMs = this.driver.getTickResolutionMs();
        long tickDuration99Ms = TimeUnit.NANOSECONDS.toMillis((long)ticks.getSnapshot().get99thPercentile());
        if (tickDuration99Ms > tickResolutionMs) {
            return ImmutableResponse.newInstance((Status)Status.Failure, (String)String.format("Ticks are taking too long. Expected rate: %d ms Duration (99 percentile): %d ms", tickResolutionMs, tickDuration99Ms));
        }
        return ImmutableResponse.newInstance((Status)Status.Success, (String)String.format("%s - Tick duration (99 percentile): %d ms", this.driver.getEngineFactory().getName(), tickDuration99Ms));
    }
}

