/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.driver.test;

import java.util.ArrayList;
import java.util.List;
import org.opennms.alec.datasource.api.InventoryObject;
import org.opennms.alec.datasource.api.InventoryObjectPeerEndpoint;
import org.opennms.alec.datasource.api.InventoryObjectPeerRef;
import org.opennms.alec.datasource.api.InventoryObjectRelativeRef;
import org.opennms.alec.datasource.common.ImmutableInventoryObject;
import org.opennms.alec.datasource.common.ImmutableInventoryObjectPeerRef;
import org.opennms.alec.datasource.common.ImmutableInventoryObjectRelativeRef;
import org.opennms.alec.driver.test.MockInventoryType;

public class MockInventoryBuilder {
    private final List<InventoryObject> inventoryObjects = new ArrayList<InventoryObject>();
    public static final long PARENT_WEIGHT = 100L;
    public static final long PEER_WEIGHT = 300L;
    public static final long RELATIVE_WEIGHT = 200L;

    public MockInventoryBuilder withInventoryObject(MockInventoryType type, String id) {
        return this.withInventoryObject(type.getType(), id);
    }

    public MockInventoryBuilder withInventoryObject(String type, String id) {
        return this.withInventoryObject(type, id, null, null);
    }

    public MockInventoryBuilder withInventoryObject(MockInventoryType type, String id, MockInventoryType parentType, String parentId) {
        return this.withInventoryObject(type.getType(), id, parentType.getType(), parentId);
    }

    public MockInventoryBuilder withInventoryObject(MockInventoryType type, String id, MockInventoryType parentType, String parentId, long weightToParent) {
        return this.withInventoryObject(type.getType(), id, parentType.getType(), parentId, weightToParent);
    }

    public MockInventoryBuilder withInventoryObject(String type, String id, String parentType, String parentId) {
        return this.withInventoryObject(type, id, parentType, parentId, 100L);
    }

    public MockInventoryBuilder withInventoryObject(String type, String id, String parentType, String parentId, long weightToParent) {
        this.inventoryObjects.add((InventoryObject)ImmutableInventoryObject.newBuilder().setType(type).setId(id).setParentType(parentType).setParentId(parentId).setWeightToParent(weightToParent).build());
        return this;
    }

    public MockInventoryBuilder withPeerRelation(MockInventoryType type, String id, MockInventoryType typeA, String idA, MockInventoryType typeZ, String idZ) {
        return this.withPeerRelation(type.getType(), id, typeA.getType(), idA, typeZ.getType(), idZ);
    }

    public MockInventoryBuilder withPeerRelation(String type, String id, String typeA, String idA, String typeZ, String idZ) {
        InventoryObject originalIo = this.getIoById(type, id);
        ImmutableInventoryObject.Builder ioBuilder = ImmutableInventoryObject.newBuilderFrom((InventoryObject)originalIo);
        ioBuilder.addPeer((InventoryObjectPeerRef)ImmutableInventoryObjectPeerRef.newBuilder().setType(typeA).setId(idA).setEndpoint(InventoryObjectPeerEndpoint.A).setWeight(300L).build());
        ioBuilder.addPeer((InventoryObjectPeerRef)ImmutableInventoryObjectPeerRef.newBuilder().setType(typeZ).setId(idZ).setEndpoint(InventoryObjectPeerEndpoint.Z).setWeight(300L).build());
        this.inventoryObjects.set(this.inventoryObjects.indexOf(originalIo), (InventoryObject)ioBuilder.build());
        return this;
    }

    public MockInventoryBuilder withRelativeRelation(MockInventoryType type, String id, MockInventoryType relativeType, String relativeId) {
        return this.withRelativeRelation(type.getType(), id, relativeType.getType(), relativeId);
    }

    public MockInventoryBuilder withRelativeRelation(String type, String id, String relativeType, String relativeId) {
        InventoryObject originalIo = this.getIoById(type, id);
        ImmutableInventoryObject.Builder ioBuilder = ImmutableInventoryObject.newBuilderFrom((InventoryObject)originalIo);
        ioBuilder.addRelative((InventoryObjectRelativeRef)ImmutableInventoryObjectRelativeRef.newBuilder().setType(relativeType).setId(relativeId).setWeight(200L).build());
        this.inventoryObjects.set(this.inventoryObjects.indexOf(originalIo), (InventoryObject)ioBuilder.build());
        return this;
    }

    private InventoryObject getIoById(String type, String id) {
        return this.inventoryObjects.stream().filter(io -> type.equals(io.getType()) && id.equals(io.getId())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Could not find element with type: %s and id: %s", type, id)));
    }

    public List<InventoryObject> getInventory() {
        return this.inventoryObjects;
    }
}

