/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.driver.test;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.datasource.api.Severity;
import org.opennms.alec.datasource.common.ImmutableAlarm;
import org.opennms.alec.driver.test.MockInventoryType;

public class MockAlarmBuilder {
    private String id;
    private String inventoryObjectId;
    private String inventoryObjectType;
    private List<MockEvent> events = new ArrayList<MockEvent>();

    public MockAlarmBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public MockAlarmBuilder withInventoryObject(MockInventoryType type, String id) {
        return this.withInventoryObject(type.getType(), id);
    }

    public MockAlarmBuilder withInventoryObject(String type, String id) {
        this.inventoryObjectType = type;
        this.inventoryObjectId = id;
        return this;
    }

    public MockAlarmBuilder withComment(String comment) {
        return this;
    }

    public MockAlarmBuilder withEvent(long time, Severity severity) {
        this.events.add(new MockEvent(time, severity));
        return this;
    }

    public List<Alarm> build() {
        this.events.sort(Comparator.comparing(MockEvent::getTime));
        ArrayList<Alarm> alarms = new ArrayList<Alarm>();
        for (MockEvent event : this.events) {
            alarms.add((Alarm)ImmutableAlarm.newBuilder().setId(this.id).setInventoryObjectType(this.inventoryObjectType).setInventoryObjectId(this.inventoryObjectId).setTime(event.getTime()).setSeverity(event.getSeverity()).build());
        }
        return alarms;
    }

    private static class MockEvent {
        private long time;
        private Severity severity;

        public MockEvent(long time, Severity severity) {
            this.time = time;
            this.severity = severity;
        }

        public long getTime() {
            return this.time;
        }

        public Severity getSeverity() {
            return this.severity;
        }
    }
}

