/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.driver.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.alec.datasource.api.InventoryObject;
import org.opennms.alec.datasource.api.InventoryObjectPeerEndpoint;
import org.opennms.alec.datasource.api.InventoryObjectPeerRef;
import org.opennms.alec.datasource.api.InventoryObjectRelativeRef;
import org.opennms.alec.datasource.api.ResourceKey;
import org.opennms.alec.datasource.common.ImmutableInventoryObject;
import org.opennms.alec.datasource.common.ImmutableInventoryObjectPeerRef;
import org.opennms.alec.datasource.common.ImmutableInventoryObjectRelativeRef;
import org.opennms.alec.driver.test.MockInventoryType;

public class MockInventoryBuilder {
    private final Map<ResourceKey, InventoryObject> inventoryObjectsById = new HashMap<ResourceKey, InventoryObject>();
    public static final long PARENT_WEIGHT = 100L;
    public static final long PEER_WEIGHT = 300L;
    public static final long RELATIVE_WEIGHT = 200L;

    public MockInventoryBuilder withInventoryObject(MockInventoryType type, String id) {
        return this.withInventoryObject(type.getType(), id);
    }

    public MockInventoryBuilder withInventoryObject(String type, String id) {
        return this.withInventoryObject(type, id, null, null);
    }

    public MockInventoryBuilder withInventoryObject(MockInventoryType type, String id, MockInventoryType parentType, String parentId) {
        return this.withInventoryObject(type.getType(), id, parentType.getType(), parentId);
    }

    public MockInventoryBuilder withInventoryObject(MockInventoryType type, String id, MockInventoryType parentType, String parentId, long weightToParent) {
        return this.withInventoryObject(type.getType(), id, parentType.getType(), parentId, weightToParent);
    }

    public MockInventoryBuilder withInventoryObject(String type, String id, String parentType, String parentId) {
        return this.withInventoryObject(type, id, parentType, parentId, 100L);
    }

    public MockInventoryBuilder withInventoryObject(String type, String id, String parentType, String parentId, long weightToParent) {
        ImmutableInventoryObject io = ImmutableInventoryObject.newBuilder().setType(type).setId(id).setParentType(parentType).setParentId(parentId).setWeightToParent(weightToParent).build();
        this.inventoryObjectsById.put(new ResourceKey(new String[]{type, id}), (InventoryObject)io);
        return this;
    }

    public MockInventoryBuilder withPeerRelation(MockInventoryType type, String id, MockInventoryType typeA, String idA, MockInventoryType typeZ, String idZ) {
        return this.withPeerRelation(type.getType(), id, typeA.getType(), idA, typeZ.getType(), idZ);
    }

    public MockInventoryBuilder withEdgeTo(String typeA, String idA, String typeZ, String idZ) {
        InventoryObject originalIo = this.getIoById(typeA, idA);
        ImmutableInventoryObject.Builder ioBuilder = ImmutableInventoryObject.newBuilderFrom((InventoryObject)originalIo);
        ioBuilder.addPeer((InventoryObjectPeerRef)ImmutableInventoryObjectPeerRef.newBuilder().setType(typeZ).setId(idZ).setEndpoint(InventoryObjectPeerEndpoint.Z).setWeight(300L).build());
        this.inventoryObjectsById.put(new ResourceKey(new String[]{originalIo.getType(), idA}), (InventoryObject)ioBuilder.build());
        return this;
    }

    public MockInventoryBuilder withPeerRelation(String type, String id, String typeA, String idA, String typeZ, String idZ) {
        InventoryObject originalIo = this.getIoById(type, id);
        ImmutableInventoryObject.Builder ioBuilder = ImmutableInventoryObject.newBuilderFrom((InventoryObject)originalIo);
        ioBuilder.addPeer((InventoryObjectPeerRef)ImmutableInventoryObjectPeerRef.newBuilder().setType(typeA).setId(idA).setEndpoint(InventoryObjectPeerEndpoint.A).setWeight(300L).build());
        ioBuilder.addPeer((InventoryObjectPeerRef)ImmutableInventoryObjectPeerRef.newBuilder().setType(typeZ).setId(idZ).setEndpoint(InventoryObjectPeerEndpoint.Z).setWeight(300L).build());
        this.inventoryObjectsById.put(new ResourceKey(new String[]{originalIo.getType(), id}), (InventoryObject)ioBuilder.build());
        return this;
    }

    public MockInventoryBuilder withRelativeRelation(MockInventoryType type, String id, MockInventoryType relativeType, String relativeId) {
        return this.withRelativeRelation(type.getType(), id, relativeType.getType(), relativeId);
    }

    public MockInventoryBuilder withRelativeRelation(String type, String id, String relativeType, String relativeId) {
        InventoryObject originalIo = this.getIoById(type, id);
        ImmutableInventoryObject.Builder ioBuilder = ImmutableInventoryObject.newBuilderFrom((InventoryObject)originalIo);
        ioBuilder.addRelative((InventoryObjectRelativeRef)ImmutableInventoryObjectRelativeRef.newBuilder().setType(relativeType).setId(relativeId).setWeight(200L).build());
        this.inventoryObjectsById.put(new ResourceKey(new String[]{originalIo.getType(), id}), (InventoryObject)ioBuilder.build());
        return this;
    }

    private InventoryObject getIoById(String type, String id) {
        ResourceKey lookup = new ResourceKey(new String[]{type, id});
        InventoryObject io = this.inventoryObjectsById.get(lookup);
        if (io == null) {
            throw new IllegalArgumentException(String.format("Could not find element with type: %s and id: %s", type, id));
        }
        return io;
    }

    public List<InventoryObject> getInventory() {
        return new ArrayList<InventoryObject>(this.inventoryObjectsById.values());
    }
}

