/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.engine.cluster;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraShortestPath;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.datasource.api.AlarmFeedback;
import org.opennms.alec.datasource.api.InventoryObject;
import org.opennms.alec.datasource.api.Situation;
import org.opennms.alec.datasource.api.SituationHandler;
import org.opennms.alec.datasource.common.ImmutableSituation;
import org.opennms.alec.engine.api.Engine;
import org.opennms.alec.engine.cluster.AlarmInSpaceTime;
import org.opennms.alec.engine.cluster.CEEdge;
import org.opennms.alec.engine.cluster.CEVertex;
import org.opennms.alec.engine.cluster.GraphManager;
import org.opennms.alec.engine.cluster.SpatialDistanceCalculator;
import org.opennms.alec.features.graph.api.Edge;
import org.opennms.alec.features.graph.api.GraphProvider;
import org.opennms.alec.features.graph.api.OceGraph;
import org.opennms.alec.features.graph.api.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClusterEngine
implements Engine,
GraphProvider,
SpatialDistanceCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClusterEngine.class);
    private static final int NUM_VERTEX_THRESHOLD_FOR_HOP_DIAG = 10;
    private final Map<String, Situation> alarmIdToSituationMap = new HashMap<String, Situation>();
    private final Map<String, Situation> situationsById = new HashMap<String, Situation>();
    private final Map<String, Set<String>> situationAlarmBlacklist = new HashMap<String, Set<String>>();
    private final Set<String> situationsWithFeedback = new HashSet<String>();
    private long tickResolutionMs = TimeUnit.SECONDS.toMillis(30L);
    private SituationHandler situationHandler;
    private long lastRun = 0L;
    private long problemTimeoutMs = TimeUnit.HOURS.toMillis(2L);
    private long clearTimeoutMs = TimeUnit.MINUTES.toMillis(5L);
    private boolean alarmsChangedSinceLastTick = false;
    private boolean feedbackChangedSinceLastTick = false;
    private DijkstraShortestPath<CEVertex, CEEdge> shortestPath;
    private Set<Long> disconnectedVertices = new HashSet<Long>();
    private final GraphManager graphManager = new GraphManager();
    private final CountDownLatch initLock = new CountDownLatch(1);
    private final LoadingCache<EdgeKey, Double> spatialDistances = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<EdgeKey, Double>(){

        public Double load(EdgeKey key) {
            Number distance;
            if (AbstractClusterEngine.this.disconnectedVertices.contains(key.vertexIdA) || AbstractClusterEngine.this.disconnectedVertices.contains(key.vertexIdB)) {
                return Integer.valueOf(Integer.MAX_VALUE).doubleValue();
            }
            CEVertex vertexA = AbstractClusterEngine.this.graphManager.getVertexWithId(key.vertexIdA);
            if (vertexA == null) {
                throw new IllegalStateException("Could not find vertex with id: " + key.vertexIdA);
            }
            CEVertex vertexB = AbstractClusterEngine.this.graphManager.getVertexWithId(key.vertexIdB);
            if (vertexB == null) {
                throw new IllegalStateException("Could not find vertex with id: " + key.vertexIdB);
            }
            if (AbstractClusterEngine.this.shortestPath == null) {
                AbstractClusterEngine.this.shortestPath = new DijkstraShortestPath(AbstractClusterEngine.this.graphManager.getGraph(), CEEdge::getWeight, true);
            }
            if ((distance = AbstractClusterEngine.this.shortestPath.getDistance((Object)vertexA, (Object)vertexB)) == null) {
                return Integer.valueOf(Integer.MAX_VALUE).doubleValue();
            }
            return distance.doubleValue();
        }
    });

    public void registerSituationHandler(SituationHandler handler) {
        this.situationHandler = handler;
    }

    public long getTickResolutionMs() {
        return this.tickResolutionMs;
    }

    public void setTickResolutionMs(long tickResolutionMs) {
        this.tickResolutionMs = tickResolutionMs;
    }

    public void tick(long timestampInMillis) {
        LOG.debug("Starting tick for {}", (Object)timestampInMillis);
        if (timestampInMillis - this.lastRun >= this.tickResolutionMs - 1L) {
            this.onTick(timestampInMillis);
            this.lastRun = timestampInMillis;
        } else {
            LOG.debug("Less than {} milliseconds elapsed since last tick. Ignoring.", (Object)this.tickResolutionMs);
        }
        LOG.debug("Done tick for {}", (Object)timestampInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(List<Alarm> alarms, List<AlarmFeedback> alarmFeedback, List<Situation> situations, List<InventoryObject> inventory) {
        try {
            LOG.debug("Initialized with {} alarms, {} alarm feedback, {} situations and {} inventory objects.", new Object[]{alarms.size(), alarmFeedback.size(), situations.size(), inventory.size()});
            LOG.trace("Alarms on init: {}", alarms);
            LOG.trace("Situations on init: {}", situations);
            LOG.trace("Inventory objects on init: {}", inventory);
            this.graphManager.addInventory(inventory);
            this.graphManager.addOrUpdateAlarms(alarms);
            situations.forEach(situation -> {
                this.situationsById.put(situation.getId(), (Situation)situation);
                if (situation.getAlarms() != null) {
                    for (Alarm alarmInSituation : situation.getAlarms()) {
                        this.alarmIdToSituationMap.put(alarmInSituation.getId(), (Situation)situation);
                    }
                }
            });
            alarmFeedback.forEach(this::handleAlarmFeedback);
            if (alarms.size() > 0) {
                this.alarmsChangedSinceLastTick = true;
            }
            this.onInit();
        }
        finally {
            this.initLock.countDown();
        }
    }

    public void onInit() {
    }

    public void destroy() {
        this.onDestroy();
    }

    public void onDestroy() {
    }

    public synchronized void deleteSituation(String situationId) throws InterruptedException {
        this.initLock.await();
        LOG.debug("Deleting situation references for situation with id: {}", (Object)situationId);
        this.situationAlarmBlacklist.remove(situationId);
        Situation situationBeingRemoved = this.situationsById.remove(situationId);
        if (situationBeingRemoved == null) {
            LOG.warn("Situation with id: {} was not found when attempting to delete.", (Object)situationId);
            return;
        }
        situationBeingRemoved.getAlarms().stream().map(Alarm::getId).forEach(this.alarmIdToSituationMap::remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onTick(long timestampInMillis) {
        if (!this.alarmsChangedSinceLastTick && !this.feedbackChangedSinceLastTick) {
            LOG.debug("{}: No alarm changes since last tick. Nothing to do.", (Object)timestampInMillis);
            return;
        }
        TickContext context = this.getTickContextFor(timestampInMillis);
        Set<String> set = this.situationsWithFeedback;
        synchronized (set) {
            if (this.feedbackChangedSinceLastTick) {
                this.feedbackChangedSinceLastTick = false;
                for (String situationId : this.situationsWithFeedback) {
                    Situation affectedSituation = this.situationsById.get(situationId);
                    if (affectedSituation == null) {
                        LOG.info("Got feedback for situation with id: {}, but the engine does not know about this situation. Ignoring feedback.");
                        continue;
                    }
                    Set prevAlarms = affectedSituation.getAlarms();
                    HashSet<Alarm> newAlarms = new HashSet<Alarm>(prevAlarms);
                    newAlarms.removeIf(alarm -> this.situationAlarmBlacklist.containsKey(situationId) && this.situationAlarmBlacklist.get(situationId).contains(alarm.getId()));
                    if (newAlarms.equals(prevAlarms)) continue;
                    context.getBuilderForExistingSituationWithId(affectedSituation.getId()).setAlarms(newAlarms);
                }
                this.situationsWithFeedback.clear();
            }
        }
        if (this.alarmsChangedSinceLastTick) {
            this.alarmsChangedSinceLastTick = false;
            this.graphManager.withGraph(g -> {
                if (this.graphManager.getDidGraphChangeAndReset()) {
                    LOG.debug("{}: Graph has changed. Resetting hop cache.", (Object)timestampInMillis);
                    this.resetHopCache();
                }
                int numGarbageCollectedAlarms = 0;
                int numAlarms = 0;
                for (CEVertex v : g.getVertices()) {
                    numGarbageCollectedAlarms += v.garbageCollectAlarms(timestampInMillis, this.problemTimeoutMs, this.clearTimeoutMs);
                    numAlarms += v.getNumAlarms();
                }
                LOG.debug("{}: Garbage collected {} alarms.", (Object)timestampInMillis, (Object)numGarbageCollectedAlarms);
                LOG.debug("{}: Clustering {} alarms.", (Object)timestampInMillis, (Object)numAlarms);
                List<Object> clustersOfAlarms = this.cluster(timestampInMillis, (Graph<CEVertex, CEEdge>)g);
                if (clustersOfAlarms == null) {
                    LOG.debug("{}: No clustering was performed.", (Object)timestampInMillis);
                    return;
                }
                clustersOfAlarms = clustersOfAlarms.stream().filter(c -> c.getPoints().size() >= 2).collect(Collectors.toList());
                LOG.debug("{}: Found {} clusters of alarms.", (Object)timestampInMillis, (Object)clustersOfAlarms.size());
                Set<String> set = this.situationsWithFeedback;
                synchronized (set) {
                    for (Cluster cluster : clustersOfAlarms) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{}: Processing cluster containing {} alarms.", (Object)timestampInMillis, (Object)cluster.getPoints().size());
                        }
                        this.mapClusterToSituations((Cluster<AlarmInSpaceTime>)cluster, context);
                    }
                }
            });
        }
        List<Situation> situations = context.getNewOrUpdatedSituations();
        LOG.debug("{}: Creating/updating {} situations.", (Object)timestampInMillis, (Object)situations.size());
        for (Situation situation : situations) {
            for (Alarm alarm2 : situation.getAlarms()) {
                this.alarmIdToSituationMap.put(alarm2.getId(), situation);
            }
            this.situationsById.put(situation.getId(), situation);
            this.situationHandler.onSituation(situation);
        }
    }

    public synchronized void resetHopCache() {
        this.spatialDistances.invalidateAll();
        this.shortestPath = null;
        this.disconnectedVertices = this.graphManager.getDisconnectedVertices();
    }

    public abstract List<Cluster<AlarmInSpaceTime>> cluster(long var1, Graph<CEVertex, CEEdge> var3);

    @VisibleForTesting
    void mapClusterToSituations(Cluster<AlarmInSpaceTime> clusterOfAlarms, TickContext context) {
        LinkedHashMap alarmsBySituationId = new LinkedHashMap();
        ArrayList<Alarm> alarmsWithoutSituations = new ArrayList<Alarm>();
        for (AlarmInSpaceTime alarmInSpaceTime : clusterOfAlarms.getPoints()) {
            Alarm alarm = alarmInSpaceTime.getAlarm();
            Situation situation = this.alarmIdToSituationMap.get(alarm.getId());
            if (situation != null) {
                alarmsBySituationId.computeIfAbsent(situation.getId(), sid -> new ArrayList()).add(alarm);
                continue;
            }
            alarmsWithoutSituations.add(alarm);
        }
        if (LOG.isDebugEnabled()) {
            LinkedHashMap alarmIdsBySituationIds = new LinkedHashMap();
            alarmsBySituationId.forEach((situationId, alarms) -> alarmIdsBySituationIds.put(situationId, alarms.stream().map(Alarm::getId).collect(Collectors.toList())));
            LOG.debug("{}: Alarms IDs by Situations IDs in the cluster: {}", (Object)context.getTimestampInMillis(), alarmIdsBySituationIds);
            List alarmIdsWithoutSituations = alarmsWithoutSituations.stream().map(Alarm::getId).collect(Collectors.toList());
            LOG.debug("{}: Alarms IDs without situations in the cluster: {}", (Object)context.getTimestampInMillis(), alarmIdsWithoutSituations);
        }
        if (alarmsWithoutSituations.isEmpty()) {
            LOG.debug("{}: All of the alarms are already in situations, nothing to do here.", (Object)context.getTimestampInMillis());
            return;
        }
        if (alarmsBySituationId.isEmpty()) {
            String situationId2 = UUID.randomUUID().toString();
            ImmutableSituation.Builder situationBuilder2 = context.getBuilderForNewSituationWithId(situationId2);
            for (AlarmInSpaceTime alarmInSpaceTime : clusterOfAlarms.getPoints()) {
                situationBuilder2.addAlarm(alarmInSpaceTime.getAlarm(), this::isAlarmBlacklistedFromSituation);
            }
            LOG.debug("{}: The alarms in the cluster are not part of a situation yet. Creating situation with id: {}", (Object)context.getTimestampInMillis(), (Object)situationId2);
        } else if (alarmsBySituationId.size() == 1) {
            String situationId2 = (String)Iterables.getFirst(alarmsBySituationId.keySet(), null);
            LOG.debug("{}: Some of the alarms in the cluster are not part of a situation yet. Adding alarms to existing situation with id: {}", (Object)context.getTimestampInMillis(), (Object)situationId2);
            ImmutableSituation.Builder situationBuilder2 = context.getBuilderForExistingSituationWithId(situationId2);
            for (AlarmInSpaceTime alarmInSpaceTime : clusterOfAlarms.getPoints()) {
                situationBuilder2.addAlarm(alarmInSpaceTime.getAlarm(), this::isAlarmBlacklistedFromSituation);
            }
        } else {
            LOG.debug("{}: Found {} unclassified alarms in a cluster with existing alarms associated to {} situations.", new Object[]{context.getTimestampInMillis(), alarmsWithoutSituations.size(), alarmsBySituationId.size()});
            List<Alarm> candidateAlarms = alarmsBySituationId.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            HashSet<String> situationsUpdated = new HashSet<String>();
            for (Alarm alarm : alarmsWithoutSituations) {
                Alarm closestNeighbor = this.getClosestNeighborInSituation(alarm, candidateAlarms);
                Situation existingSituationForClosestNeighbor = this.alarmIdToSituationMap.get(closestNeighbor.getId());
                String existingSituationId = existingSituationForClosestNeighbor.getId();
                ImmutableSituation.Builder situationBuilder3 = context.getBuilderForExistingSituationWithId(existingSituationId);
                situationBuilder3.addAlarm(alarm, this::isAlarmBlacklistedFromSituation);
                situationsUpdated.add(existingSituationId);
            }
            for (String string : situationsUpdated) {
                ImmutableSituation.Builder situationBuilder4 = context.getBuilderForExistingSituationWithId(string);
                for (Alarm alarm : alarmsBySituationId.getOrDefault(string, Collections.emptyList())) {
                    situationBuilder4.addAlarm(alarm, this::isAlarmBlacklistedFromSituation);
                }
            }
        }
        Collection<ImmutableSituation.Builder> situationBuilders = context.getBuildersForNewOrUpdatedSituations();
        LOG.debug("{}: Generating diagnostic texts for {} situations...", (Object)context.getTimestampInMillis(), (Object)situationBuilders.size());
        situationBuilders.forEach(situationBuilder -> situationBuilder.setDiagnosticText(this.getDiagnosticTextForSituation((Situation)situationBuilder.build())));
        LOG.debug("{}: Done generating diagnostic texts.", (Object)context.getTimestampInMillis());
    }

    private boolean isAlarmBlacklistedFromSituation(String alarmId, String situationId) {
        if (this.situationAlarmBlacklist.containsKey(situationId) && this.situationAlarmBlacklist.get(situationId).contains(alarmId)) {
            LOG.debug("Alarm with id: {} is blacklisted from situation with id: {} and will not be added.", (Object)alarmId, (Object)situationId);
            return false;
        }
        return true;
    }

    private String getDiagnosticTextForSituation(Situation situation) {
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        Double maxSpatialDistance = null;
        HashSet vertexIds = new HashSet();
        for (Alarm alarm : situation.getAlarms()) {
            minTime = Math.min(minTime, alarm.getTime());
            maxTime = Math.max(maxTime, alarm.getTime());
            this.getOptionalVertexIdForAlarm(alarm).ifPresent(vertexIds::add);
        }
        if (vertexIds.size() < 10) {
            maxSpatialDistance = 0.0;
            for (Long vertexIdA : vertexIds) {
                for (Long vertexIdB : vertexIds) {
                    if (vertexIdA.equals(vertexIdB)) continue;
                    maxSpatialDistance = Math.max(maxSpatialDistance, this.getSpatialDistanceBetween(vertexIdA, vertexIdB));
                }
            }
        }
        String diagText = String.format("The %d alarms happened within %.2f seconds across %d vertices", situation.getAlarms().size(), (double)Math.abs(maxTime - minTime) / 1000.0, vertexIds.size());
        if (maxSpatialDistance != null && maxSpatialDistance > 0.0) {
            diagText = diagText + String.format(" %.2f distance apart", maxSpatialDistance);
        }
        diagText = diagText + ".";
        return diagText;
    }

    public void onAlarmCreatedOrUpdated(Alarm alarm) {
        try {
            this.initLock.await();
            this.graphManager.addOrUpdateAlarm(alarm);
            this.alarmsChangedSinceLastTick = true;
        }
        catch (InterruptedException ignore) {
            LOG.debug("Interrupted while handling callback, skipping processing onAlarmCreatedOrUpdated.");
            Thread.currentThread().interrupt();
        }
    }

    public void onAlarmCleared(Alarm alarm) {
        try {
            this.initLock.await();
            this.graphManager.addOrUpdateAlarm(alarm);
            this.alarmsChangedSinceLastTick = true;
        }
        catch (InterruptedException ignore) {
            LOG.debug("Interrupted while handling callback, skipping processing onAlarmCleared.");
            Thread.currentThread().interrupt();
        }
    }

    public void onInventoryAdded(Collection<InventoryObject> inventory) {
        try {
            this.initLock.await();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Adding inventory {}", inventory);
            }
            this.graphManager.addInventory(inventory);
            if (LOG.isTraceEnabled()) {
                LOG.trace("There are now {} vertices", (Object)this.graphManager.getGraph().getVertexCount());
                LOG.trace("There are now {} edges", (Object)this.graphManager.getGraph().getEdgeCount());
            }
        }
        catch (InterruptedException ignore) {
            LOG.debug("Interrupted while handling callback, skipping processing onInventoryAdded.");
            Thread.currentThread().interrupt();
        }
    }

    public void onInventoryRemoved(Collection<InventoryObject> inventory) {
        try {
            this.initLock.await();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Removing inventory {}", inventory);
            }
            this.graphManager.removeInventory(inventory);
            if (LOG.isTraceEnabled()) {
                LOG.trace("There are now {} vertices", (Object)this.graphManager.getGraph().getVertexCount());
                LOG.trace("There are now {} edges", (Object)this.graphManager.getGraph().getEdgeCount());
            }
        }
        catch (InterruptedException ignore) {
            LOG.debug("Interrupted while handling callback, skipping processing onInventoryRemoved.");
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarmFeedback(AlarmFeedback alarmFeedback) {
        Set<String> set = this.situationsWithFeedback;
        synchronized (set) {
            this.feedbackChangedSinceLastTick = true;
            switch (alarmFeedback.getFeedbackType()) {
                case FALSE_POSITIVE: {
                    this.situationAlarmBlacklist.compute(alarmFeedback.getSituationId(), (key, value) -> {
                        Set alarmIds = value == null ? new HashSet() : value;
                        alarmIds.add(alarmFeedback.getAlarmKey());
                        return alarmIds;
                    });
                    this.situationsWithFeedback.add(alarmFeedback.getSituationId());
                    break;
                }
                case FALSE_NEGATIVE: {
                    if (!this.situationAlarmBlacklist.containsKey(alarmFeedback.getSituationId())) break;
                    this.situationAlarmBlacklist.get(alarmFeedback.getSituationId()).remove(alarmFeedback.getAlarmKey());
                }
            }
        }
    }

    public <V> V withReadOnlyGraph(Function<OceGraph, V> consumer) {
        ArrayList<Situation> situations = new ArrayList<Situation>(this.situationsById.values());
        return (V)this.graphManager.withReadOnlyGraph((Graph<? extends Vertex, ? extends Edge> g) -> {
            OceGraph oceGraph = new OceGraph((Graph)g, situations){
                final /* synthetic */ Graph val$g;
                final /* synthetic */ List val$situations;
                {
                    this.val$g = graph;
                    this.val$situations = list;
                }

                public Graph<? extends Vertex, ? extends Edge> getGraph() {
                    return this.val$g;
                }

                public List<Situation> getSituations() {
                    return this.val$situations;
                }

                public Vertex getVertexById(String id) {
                    Long idAsLong;
                    if (id == null) {
                        idAsLong = null;
                    } else {
                        try {
                            idAsLong = Long.valueOf(id);
                        }
                        catch (NumberFormatException nfe) {
                            return null;
                        }
                    }
                    return AbstractClusterEngine.this.graphManager.getVertexWithId(idAsLong);
                }
            };
            return consumer.apply(oceGraph);
        });
    }

    public void withReadOnlyGraph(Consumer<OceGraph> consumer) {
        this.withReadOnlyGraph((OceGraph g) -> {
            consumer.accept((OceGraph)g);
            return null;
        });
    }

    private Optional<Long> getOptionalVertexIdForAlarm(Alarm alarm) {
        return this.graphManager.withGraph(g -> {
            for (CEVertex v : this.graphManager.getGraph().getVertices()) {
                Optional<Alarm> match = v.getAlarms().stream().filter(a -> a.equals(alarm)).findFirst();
                if (!match.isPresent()) continue;
                return Optional.of(v.getNumericId());
            }
            return Optional.empty();
        });
    }

    private long getVertexIdForAlarm(Alarm alarm) {
        Optional<Long> vertexId = this.getOptionalVertexIdForAlarm(alarm);
        if (vertexId.isPresent()) {
            return vertexId.get();
        }
        throw new IllegalStateException("No vertex found for alarm: " + alarm);
    }

    public double getDistanceBetween(double t1, double t2, double distance) {
        return Math.abs(t2 - t1) + distance;
    }

    private Alarm getClosestNeighborInSituation(Alarm alarm, List<Alarm> candidates) {
        long vertexIdA = this.getVertexIdForAlarm(alarm);
        double timeA = alarm.getTime();
        return candidates.stream().map(candidate -> {
            double timeB = candidate.getTime();
            long vertexIdB = this.getVertexIdForAlarm((Alarm)candidate);
            double spatialDistance = vertexIdA == vertexIdB ? 0.0 : this.getSpatialDistanceBetween(vertexIdA, vertexIdB);
            double distance = this.getDistanceBetween(timeA, timeB, spatialDistance);
            return new CandidateAlarmWithDistance((Alarm)candidate, distance);
        }).min(Comparator.comparingDouble(CandidateAlarmWithDistance::getDistance).thenComparing(c -> c.getAlarm().getId())).orElseThrow(() -> new IllegalStateException("Should not happen!")).alarm;
    }

    @Override
    public double getSpatialDistanceBetween(long vertexIdA, long vertexIdB) {
        EdgeKey key = new EdgeKey(vertexIdA, vertexIdB);
        try {
            return (Double)this.spatialDistances.get((Object)key);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, AlarmInSpaceTime> findAlarmsWithIds(String ... alarmIds) {
        HashSet<String> alarmIdsToFind = new HashSet<String>(Arrays.asList(alarmIds));
        HashMap<String, AlarmInSpaceTime> alarmsById = new HashMap<String, AlarmInSpaceTime>();
        this.graphManager.withGraph(g -> {
            for (CEVertex v : g.getVertices()) {
                for (Alarm a : v.getAlarms()) {
                    if (alarmIdsToFind.contains(a.getId())) {
                        alarmsById.put(a.getId(), new AlarmInSpaceTime(v, a));
                        alarmIdsToFind.remove(a.getId());
                    }
                    if (!alarmIdsToFind.isEmpty()) continue;
                    return;
                }
            }
        });
        return alarmsById;
    }

    @VisibleForTesting
    Graph<CEVertex, CEEdge> getGraph() {
        return this.graphManager.getGraph();
    }

    @VisibleForTesting
    TickContext getTickContextFor(long timestampInMillis) {
        return new TickContext(timestampInMillis);
    }

    @VisibleForTesting
    void setSituations(Collection<Situation> situations) {
        this.alarmIdToSituationMap.clear();
        this.situationsById.clear();
        for (Situation situation : situations) {
            this.situationsById.put(situation.getId(), situation);
            for (Alarm alarm : situation.getAlarms()) {
                this.alarmIdToSituationMap.put(alarm.getId(), situation);
            }
        }
    }

    Map<String, Situation> getSituationsById() {
        return ImmutableMap.copyOf(this.situationsById);
    }

    public GraphManager getGraphManager() {
        return this.graphManager;
    }

    private static class EdgeKey {
        private long vertexIdA;
        private long vertexIdB;

        private EdgeKey(long vertexIdA, long vertexIdB) {
            if (vertexIdA <= vertexIdB) {
                this.vertexIdA = vertexIdA;
                this.vertexIdB = vertexIdB;
            } else {
                this.vertexIdA = vertexIdB;
                this.vertexIdB = vertexIdA;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdgeKey edgeKey = (EdgeKey)o;
            return this.vertexIdA == edgeKey.vertexIdA && this.vertexIdB == edgeKey.vertexIdB;
        }

        public int hashCode() {
            return Objects.hash(this.vertexIdA, this.vertexIdB);
        }
    }

    private static class CandidateAlarmWithDistance {
        private final Alarm alarm;
        private final double distance;

        private CandidateAlarmWithDistance(Alarm alarm, double distance) {
            this.alarm = alarm;
            this.distance = distance;
        }

        public Alarm getAlarm() {
            return this.alarm;
        }

        public double getDistance() {
            return this.distance;
        }
    }

    class TickContext {
        private final long timestampInMillis;
        private final Map<String, ImmutableSituation.Builder> newOrUpdatedSituationsById = new LinkedHashMap<String, ImmutableSituation.Builder>();

        TickContext(long timestampInMillis) {
            this.timestampInMillis = timestampInMillis;
        }

        long getTimestampInMillis() {
            return this.timestampInMillis;
        }

        Collection<ImmutableSituation.Builder> getBuildersForNewOrUpdatedSituations() {
            return this.newOrUpdatedSituationsById.values();
        }

        ImmutableSituation.Builder getBuilderForExistingSituationWithId(String situationId) {
            Situation existingSituation = (Situation)AbstractClusterEngine.this.situationsById.get(situationId);
            if (existingSituation == null) {
                throw new IllegalArgumentException("Situation with id: " + situationId + " does not exist.");
            }
            return this.newOrUpdatedSituationsById.computeIfAbsent(situationId, sid -> ImmutableSituation.newBuilderFrom((Situation)existingSituation));
        }

        ImmutableSituation.Builder getBuilderForNewSituationWithId(String situationId) {
            ImmutableSituation.Builder situationBuilder = ImmutableSituation.newBuilder().setId(situationId).setCreationTime(this.timestampInMillis);
            this.newOrUpdatedSituationsById.put(situationId, situationBuilder);
            return situationBuilder;
        }

        List<Situation> getNewOrUpdatedSituations() {
            return this.newOrUpdatedSituationsById.values().stream().map(ImmutableSituation.Builder::build).collect(Collectors.toList());
        }
    }
}

