/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.engine.cluster;

import java.util.Optional;
import org.opennms.alec.datasource.api.InventoryObjectPeerRef;
import org.opennms.alec.datasource.api.InventoryObjectRelativeRef;
import org.opennms.alec.features.graph.api.Edge;

public class CEEdge
implements Edge {
    private final long id;
    private InventoryObjectPeerRef peerRef;
    private InventoryObjectRelativeRef relativeRef;
    private final long createdTimestamp;
    private final long weight;

    private CEEdge(long id, long weight) {
        this.id = id;
        this.weight = weight;
        this.createdTimestamp = System.currentTimeMillis();
    }

    public static CEEdge newParentEdge(long id, long weight) {
        return new CEEdge(id, weight);
    }

    public static CEEdge newPeerEdge(long id, InventoryObjectPeerRef peerRef) {
        CEEdge peerEdge = new CEEdge(id, peerRef.getWeight());
        peerEdge.peerRef = peerRef;
        return peerEdge;
    }

    public static CEEdge newRelativeEdge(long id, InventoryObjectRelativeRef relativeRef) {
        CEEdge relativeEdge = new CEEdge(id, relativeRef.getWeight());
        relativeEdge.relativeRef = relativeRef;
        return relativeEdge;
    }

    public String getId() {
        return Long.toString(this.id);
    }

    public Optional<InventoryObjectPeerRef> getInventoryObjectPeerRef() {
        return Optional.ofNullable(this.peerRef);
    }

    public Optional<InventoryObjectRelativeRef> getInventoryObjectRelativeRef() {
        return Optional.ofNullable(this.relativeRef);
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public long getWeight() {
        return this.weight;
    }
}

