/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.engine.cluster;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.datasource.api.InventoryObject;
import org.opennms.alec.datasource.api.ResourceKey;
import org.opennms.alec.engine.cluster.AbstractClusterEngine;
import org.opennms.alec.features.graph.api.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CEVertex
implements Vertex {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClusterEngine.class);
    private final long id;
    private InventoryObject inventoryObject;
    private final ResourceKey resourceKey;
    private final Map<String, Alarm> alarmsById = new LinkedHashMap<String, Alarm>();
    private final long createdTimestamp;
    private long updatedTimestamp;

    public CEVertex(long id, ResourceKey resourceKey) {
        this(id, resourceKey, null);
    }

    public CEVertex(long id, ResourceKey resourceKey, InventoryObject inventoryObject) {
        this.id = id;
        this.resourceKey = Objects.requireNonNull(resourceKey);
        this.inventoryObject = inventoryObject;
        this.updatedTimestamp = this.createdTimestamp = System.currentTimeMillis();
    }

    public void setInventoryObject(InventoryObject inventoryObject) {
        this.inventoryObject = inventoryObject;
    }

    public ResourceKey getResourceKey() {
        return this.resourceKey;
    }

    public void addOrUpdateAlarm(Alarm alarm) {
        this.alarmsById.put(alarm.getId(), alarm);
        this.updatedTimestamp = System.currentTimeMillis();
    }

    public Collection<Alarm> getAlarms() {
        return this.alarmsById.values();
    }

    public int getNumAlarms() {
        return this.alarmsById.size();
    }

    public boolean hasAlarms() {
        return !this.alarmsById.isEmpty();
    }

    public Optional<InventoryObject> getInventoryObject() {
        return Optional.ofNullable(this.inventoryObject);
    }

    public String getId() {
        return Long.toString(this.id);
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public long getUpdatedTimestamp() {
        return this.updatedTimestamp;
    }

    public long getNumericId() {
        return this.id;
    }

    public int garbageCollectAlarms(long timestampInMillis, long problemTimeoutMs, long clearTimeoutMs) {
        long problemCutoffMs = timestampInMillis - problemTimeoutMs;
        long clearCutoffMs = timestampInMillis - clearTimeoutMs;
        int numAlarmsBefore = this.alarmsById.size();
        this.alarmsById.entrySet().removeIf(entry -> {
            Alarm alarm = (Alarm)entry.getValue();
            if (alarm.isClear() && alarm.getTime() < clearCutoffMs) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("GCing cleared alarm with id: {}, alarm time is: {} which is before the cutoff time of: {}", new Object[]{alarm.getId(), new Date(alarm.getTime()), new Date(clearCutoffMs)});
                }
                return true;
            }
            if (!alarm.isClear() && alarm.getTime() < problemCutoffMs) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("GCing problem alarm with id: {}, alarm time is: {} which is before the cutoff time of: {}", new Object[]{alarm.getId(), new Date(alarm.getTime()), new Date(problemCutoffMs)});
                }
                return true;
            }
            return false;
        });
        return numAlarmsBefore - this.alarmsById.size();
    }

    public String toString() {
        return String.format("CEVertex[id=%s, resourceKey=%s]", this.id, this.resourceKey);
    }
}

